/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr.pacman;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import org.apache.maven.jxr.pacman.ClassType;
import org.apache.maven.jxr.pacman.ImportType;
import org.apache.maven.jxr.pacman.JavaFile;
import org.apache.maven.jxr.pacman.PackageType;

public class JavaFileImpl
extends JavaFile {
    private Reader reader;

    public JavaFileImpl(String filename, String encoding) throws IOException {
        this.setFilename(filename);
        this.setEncoding(encoding);
        this.addImportType(new ImportType("java.lang.*"));
        this.parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() throws IOException {
        StreamTokenizer stok = null;
        try {
            stok = this.getTokenizer();
            while (stok.nextToken() != -1) {
                if (stok.sval == null) continue;
                if (stok.sval.equals("package")) {
                    stok.nextToken();
                    this.setPackageType(new PackageType(stok.sval));
                }
                if (stok.sval.equals("import")) {
                    stok.nextToken();
                    String name = stok.sval;
                    if (name.charAt(name.length() - 1) == '.') {
                        name = name + "*";
                    }
                    this.addImportType(new ImportType(name));
                }
                if (!stok.sval.equals("class") && !stok.sval.equals("interface") && !stok.sval.equals("enum")) continue;
                stok.nextToken();
                this.setClassType(new ClassType(stok.sval));
                break;
            }
        }
        finally {
            stok = null;
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    private StreamTokenizer getTokenizer() throws IOException {
        if (!new File(this.getFilename()).exists()) {
            throw new IOException(this.getFilename() + " does not exist!");
        }
        this.reader = this.getEncoding() != null ? new InputStreamReader((InputStream)new FileInputStream(this.getFilename()), this.getEncoding()) : new FileReader(this.getFilename());
        StreamTokenizer stok = new StreamTokenizer(this.reader);
        stok.commentChar(42);
        stok.wordChars(95, 95);
        stok.slashStarComments(true);
        stok.slashSlashComments(true);
        return stok;
    }
}

