/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.siterenderer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.skin.SkinModel;
import org.apache.maven.doxia.siterenderer.ExtraDoxiaModuleReference;
import org.codehaus.plexus.util.ReaderFactory;

public class SiteRenderingContext {
    private String inputEncoding = ReaderFactory.FILE_ENCODING;
    private String outputEncoding = "UTF-8";
    private String templateName;
    private ClassLoader templateClassLoader;
    private Map<String, ?> templateProperties;
    private Locale locale = Locale.ROOT;
    private List<Locale> siteLocales = new ArrayList<Locale>();
    private DecorationModel decoration;
    private String defaultWindowTitle;
    private Artifact skin;
    private SkinModel skinModel;
    private File rootDirectory;
    private List<File> siteDirectories = new ArrayList<File>();
    private Map<String, String> moduleExcludes;
    private List<ExtraDoxiaModuleReference> modules = new ArrayList<ExtraDoxiaModuleReference>();
    private boolean validate;
    private Date publishDate;
    private File processedContentOutput;

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public ClassLoader getTemplateClassLoader() {
        return this.templateClassLoader;
    }

    public void setTemplateClassLoader(ClassLoader templateClassLoader) {
        this.templateClassLoader = templateClassLoader;
    }

    public Map<String, ?> getTemplateProperties() {
        return this.templateProperties;
    }

    public void setTemplateProperties(Map<String, ?> templateProperties) {
        this.templateProperties = Collections.unmodifiableMap(templateProperties);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public List<Locale> getSiteLocales() {
        return this.siteLocales;
    }

    public void addSiteLocales(List<Locale> locales) {
        this.siteLocales.addAll(locales);
    }

    public DecorationModel getDecoration() {
        return this.decoration;
    }

    public void setDecoration(DecorationModel decoration) {
        this.decoration = decoration;
    }

    public void setDefaultWindowTitle(String defaultWindowTitle) {
        this.defaultWindowTitle = defaultWindowTitle;
    }

    public String getDefaultWindowTitle() {
        return this.defaultWindowTitle;
    }

    public Artifact getSkin() {
        return this.skin;
    }

    public void setSkin(Artifact skin) {
        this.skin = skin;
    }

    public SkinModel getSkinModel() {
        return this.skinModel;
    }

    public void setSkinModel(SkinModel skinModel) {
        this.skinModel = skinModel;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void addSiteDirectory(File siteDirectory) {
        this.siteDirectories.add(siteDirectory);
    }

    public void addModuleDirectory(File moduleBasedir, String moduleParserId) {
        this.modules.add(new ExtraDoxiaModuleReference(moduleParserId, moduleBasedir));
    }

    public List<File> getSiteDirectories() {
        return this.siteDirectories;
    }

    public List<ExtraDoxiaModuleReference> getModules() {
        return this.modules;
    }

    public Map<String, String> getModuleExcludes() {
        return this.moduleExcludes;
    }

    public void setModuleExcludes(Map<String, String> moduleExcludes) {
        this.moduleExcludes = moduleExcludes;
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public void setInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public Date getPublishDate() {
        return this.publishDate;
    }

    public void setPublishDate(Date publishDate) {
        this.publishDate = publishDate;
    }

    public File getProcessedContentOutput() {
        return this.processedContentOutput;
    }

    public void setProcessedContentOutput(File processedContentOutput) {
        this.processedContentOutput = processedContentOutput;
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }
}

