/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.markdown;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.module.markdown.MarkdownMarkup;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.AbstractTextSink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownSink
extends AbstractTextSink
implements MarkdownMarkup {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarkdownSink.class);
    private StringBuffer buffer;
    private StringBuilder tableCaptionBuffer;
    private Collection<String> authors;
    private String title;
    private String date;
    private String linkName;
    private boolean startFlag;
    private boolean tableCaptionFlag;
    private boolean tableCellFlag;
    private boolean headerFlag;
    private boolean bufferFlag;
    private boolean itemFlag;
    private boolean verbatimFlag;
    private boolean gridFlag;
    private int cellCount;
    private final PrintWriter writer;
    private boolean isWriterAtStartOfNewLine;
    private int[] cellJustif;
    private String rowLine;
    private boolean headerRow;
    private int listNestingLevel;
    private final Stack<String> listStyles;
    protected Stack<List<String>> inlineStack = new Stack();

    protected MarkdownSink(Writer writer) {
        this.writer = new PrintWriter(writer);
        this.isWriterAtStartOfNewLine = true;
        this.listStyles = new Stack();
        this.init();
    }

    protected StringBuffer getBuffer() {
        return this.buffer;
    }

    protected void setHeadFlag(boolean headFlag) {
        this.headerFlag = headFlag;
    }

    protected void init() {
        super.init();
        this.resetBuffer();
        this.tableCaptionBuffer = new StringBuilder();
        this.listNestingLevel = 0;
        this.authors = new LinkedList<String>();
        this.title = null;
        this.date = null;
        this.linkName = null;
        this.startFlag = true;
        this.tableCaptionFlag = false;
        this.tableCellFlag = false;
        this.headerFlag = false;
        this.bufferFlag = false;
        this.itemFlag = false;
        this.verbatimFlag = false;
        this.gridFlag = false;
        this.cellCount = 0;
        this.cellJustif = null;
        this.rowLine = null;
        this.listStyles.clear();
        this.inlineStack.clear();
    }

    protected void resetBuffer() {
        this.buffer = new StringBuffer();
    }

    protected void resetTableCaptionBuffer() {
        this.tableCaptionBuffer = new StringBuilder();
    }

    public void head() {
        boolean startFlag = this.startFlag;
        this.init();
        this.headerFlag = true;
        this.startFlag = startFlag;
    }

    public void head_() {
        this.headerFlag = false;
        if (this.title == null && this.authors.isEmpty() && this.date == null) {
            return;
        }
        this.write(METADATA_MARKUP + EOL);
        if (this.title != null) {
            this.write("title: " + this.title + EOL);
        }
        if (!this.authors.isEmpty()) {
            this.write("author: " + EOL);
            for (String author : this.authors) {
                this.write("  - " + author + EOL);
            }
        }
        if (this.date != null) {
            this.write("date: " + this.date + EOL);
        }
        this.write(METADATA_MARKUP + BLANK_LINE);
    }

    public void title_() {
        if (this.buffer.length() > 0) {
            this.title = this.buffer.toString();
            this.resetBuffer();
        }
    }

    public void author_() {
        if (this.buffer.length() > 0) {
            this.authors.add(this.buffer.toString());
            this.resetBuffer();
        }
    }

    public void date_() {
        if (this.buffer.length() > 0) {
            this.date = this.buffer.toString();
            this.resetBuffer();
        }
    }

    private void sectionTitle(int level) {
        this.write(StringUtils.repeat((String)"#", (int)level) + ' ');
    }

    public void sectionTitle1() {
        this.sectionTitle(1);
    }

    public void sectionTitle1_() {
        this.write(BLANK_LINE);
    }

    public void sectionTitle2() {
        this.sectionTitle(2);
    }

    public void sectionTitle2_() {
        this.write(BLANK_LINE);
    }

    public void sectionTitle3() {
        this.sectionTitle(3);
    }

    public void sectionTitle3_() {
        this.write(BLANK_LINE);
    }

    public void sectionTitle4() {
        this.sectionTitle(4);
    }

    public void sectionTitle4_() {
        this.write(BLANK_LINE);
    }

    public void sectionTitle5() {
        this.sectionTitle(5);
    }

    public void sectionTitle5_() {
        this.write(BLANK_LINE);
    }

    public void list() {
        ++this.listNestingLevel;
        this.listStyles.push("-");
    }

    public void list_() {
        --this.listNestingLevel;
        if (this.listNestingLevel == 0) {
            this.write(EOL);
        }
        this.listStyles.pop();
        this.itemFlag = false;
    }

    public void listItem() {
        this.orderedOrUnorderedListItem();
    }

    public void listItem_() {
        this.orderedOrUnorderedListItem_();
    }

    public void numberedList(int numbering) {
        ++this.listNestingLevel;
        if (numbering != 0) {
            LOGGER.warn("Markdown only supports numbered item with decimal style ({}) but requested was style {}, falling back to decimal style", (Object)0, (Object)numbering);
        }
        String style = "1.";
        this.listStyles.push(style);
    }

    public void numberedList_() {
        --this.listNestingLevel;
        if (this.listNestingLevel == 0) {
            this.write(EOL);
        }
        this.listStyles.pop();
        this.itemFlag = false;
    }

    public void numberedListItem() {
        this.orderedOrUnorderedListItem();
    }

    public void numberedListItem_() {
        this.orderedOrUnorderedListItem_();
    }

    private void orderedOrUnorderedListItem() {
        this.write(this.getListPrefix());
        this.itemFlag = true;
    }

    private void orderedOrUnorderedListItem_() {
        this.ensureBeginningOfLine();
        this.itemFlag = false;
    }

    private String getListPrefix() {
        StringBuilder prefix = new StringBuilder();
        for (int indent = 1; indent < this.listNestingLevel; ++indent) {
            prefix.append("    ");
        }
        prefix.append(this.listStyles.peek());
        prefix.append(' ');
        return prefix.toString();
    }

    public void definitionList() {
        LOGGER.warn("Definition list not natively supported in Markdown, rendering HTML instead");
        this.write("<dl>" + EOL);
    }

    public void definitionList_() {
        this.verbatimFlag = true;
        this.write("</dl>" + BLANK_LINE);
    }

    public void definedTerm() {
        this.write("<dt>");
        this.verbatimFlag = false;
    }

    public void definedTerm_() {
        this.write("</dt>" + EOL);
    }

    public void definition() {
        this.write("<dd>");
    }

    public void definition_() {
        this.write("</dd>" + EOL);
    }

    public void pageBreak() {
        LOGGER.warn("Ignoring unsupported page break in Markdown");
    }

    public void paragraph() {
        this.ensureBeginningOfLine();
    }

    public void paragraph_() {
        if (!this.tableCellFlag && this.listNestingLevel <= 0) {
            this.write(BLANK_LINE);
        }
    }

    public void verbatim() {
        this.verbatim(null);
    }

    public void verbatim(SinkEventAttributes attributes) {
        this.ensureBeginningOfLine();
        this.verbatimFlag = true;
        this.write("```" + EOL);
    }

    public void verbatim_() {
        this.ensureBeginningOfLine();
        this.write("```" + BLANK_LINE);
        this.verbatimFlag = false;
    }

    public void horizontalRule() {
        this.ensureBeginningOfLine();
        this.write("***" + BLANK_LINE);
    }

    public void table() {
        this.ensureBeginningOfLine();
    }

    public void table_() {
        if (this.tableCaptionBuffer.length() > 0) {
            this.text(this.tableCaptionBuffer.toString() + EOL);
        }
        this.resetTableCaptionBuffer();
    }

    public void tableRows(int[] justification, boolean grid) {
        this.cellJustif = null;
        this.gridFlag = grid;
        this.headerRow = true;
    }

    public void tableRows_() {
        this.cellJustif = null;
        this.gridFlag = false;
    }

    public void tableRow() {
        this.bufferFlag = true;
        this.cellCount = 0;
    }

    public void tableRow_() {
        this.bufferFlag = false;
        this.buildRowLine();
        this.write(TABLE_ROW_SEPARATOR_MARKUP);
        this.write(this.buffer.toString());
        this.resetBuffer();
        this.write(EOL);
        if (this.headerRow) {
            this.write(this.rowLine);
            this.headerRow = false;
        }
        this.cellCount = 0;
    }

    private void buildRowLine() {
        StringBuilder rLine = new StringBuilder(TABLE_ROW_SEPARATOR_MARKUP);
        for (int i = 0; i < this.cellCount; ++i) {
            if (this.cellJustif != null) {
                switch (this.cellJustif[i]) {
                    case 1: {
                        rLine.append(TABLE_COL_LEFT_ALIGNED_MARKUP);
                        break;
                    }
                    case 2: {
                        rLine.append(TABLE_COL_RIGHT_ALIGNED_MARKUP);
                        break;
                    }
                    default: {
                        rLine.append(TABLE_COL_DEFAULT_ALIGNED_MARKUP);
                        break;
                    }
                }
                continue;
            }
            rLine.append(TABLE_COL_DEFAULT_ALIGNED_MARKUP);
        }
        rLine.append(EOL);
        this.rowLine = rLine.toString();
    }

    public void tableCell() {
        this.tableCell(false);
    }

    public void tableHeaderCell() {
        this.tableCell(true);
    }

    public void tableCell(boolean headerRow) {
        this.tableCellFlag = true;
    }

    public void tableCell_() {
        this.endTableCell();
    }

    public void tableHeaderCell_() {
        this.endTableCell();
    }

    private void endTableCell() {
        this.tableCellFlag = false;
        this.buffer.append(TABLE_CELL_SEPARATOR_MARKUP);
        ++this.cellCount;
    }

    public void tableCaption() {
        this.tableCaptionFlag = true;
    }

    public void tableCaption_() {
        this.tableCaptionFlag = false;
    }

    public void figureCaption_() {
        this.write(EOL);
    }

    public void figureGraphics(String name) {
        this.write("<img src=\"" + name + "\" />");
    }

    public void anchor(String name) {
    }

    public void anchor_() {
    }

    public void link(String name) {
        if (!this.headerFlag) {
            this.write("[");
            this.linkName = name;
        }
    }

    public void link_() {
        if (!this.headerFlag) {
            this.write("](");
            this.text(this.linkName.startsWith("#") ? this.linkName.substring(1) : this.linkName);
            this.write(")");
            this.linkName = null;
        }
    }

    public void link(String name, String target) {
        if (!this.headerFlag) {
            this.write("[");
        }
    }

    public void inline() {
        this.inline(null);
    }

    public void inline(SinkEventAttributes attributes) {
        if (!this.headerFlag && !this.verbatimFlag) {
            ArrayList<String> tags = new ArrayList<String>();
            if (attributes != null) {
                if (attributes.containsAttribute((Object)"semantics", (Object)"italic")) {
                    this.write("_");
                    tags.add(0, "_");
                }
                if (attributes.containsAttribute((Object)"semantics", (Object)"bold")) {
                    this.write("**");
                    tags.add(0, "**");
                }
                if (attributes.containsAttribute((Object)"semantics", (Object)"code")) {
                    this.write("`");
                    tags.add(0, "`");
                }
            }
            this.inlineStack.push(tags);
        }
    }

    public void inline_() {
        if (!this.headerFlag && !this.verbatimFlag) {
            for (String tag : this.inlineStack.pop()) {
                this.write(tag);
            }
        }
    }

    public void italic() {
        this.inline(SinkEventAttributeSet.Semantics.ITALIC);
    }

    public void italic_() {
        this.inline_();
    }

    public void bold() {
        this.inline(SinkEventAttributeSet.Semantics.BOLD);
    }

    public void bold_() {
        this.inline_();
    }

    public void monospaced() {
        this.inline(SinkEventAttributeSet.Semantics.CODE);
    }

    public void monospaced_() {
        this.inline_();
    }

    public void lineBreak() {
        if (this.headerFlag || this.bufferFlag) {
            this.buffer.append(EOL);
        } else if (this.verbatimFlag) {
            this.write(EOL);
        } else {
            this.write("  " + EOL);
        }
    }

    public void nonBreakingSpace() {
        if (this.headerFlag || this.bufferFlag) {
            this.buffer.append("&nbsp;");
        } else {
            this.write("&nbsp;");
        }
    }

    public void text(String text) {
        if (this.tableCaptionFlag) {
            this.tableCaptionBuffer.append(text);
        } else if (this.headerFlag || this.bufferFlag) {
            this.buffer.append(text);
        } else if (this.verbatimFlag) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
    }

    public void rawText(String text) {
        this.write(text);
    }

    public void comment(String comment) {
        this.rawText((this.startFlag ? "" : EOL) + "<!-- " + comment + " -->");
    }

    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        LOGGER.warn("Unknown Sink event '" + name + "', ignoring!");
    }

    protected void write(String text) {
        this.startFlag = false;
        if (this.tableCellFlag) {
            this.buffer.append(text);
        } else {
            String unifiedText = MarkdownSink.unifyEOLs((String)text);
            this.isWriterAtStartOfNewLine = unifiedText.endsWith(EOL);
            this.writer.write(unifiedText);
        }
    }

    protected void content(String text) {
        this.write(MarkdownSink.escapeMarkdown(text));
    }

    protected void verbatimContent(String text) {
        this.write(text);
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        this.writer.close();
        this.init();
    }

    private static String escapeMarkdown(String text) {
        if (text == null) {
            return "";
        }
        int length = text.length();
        StringBuilder buffer = new StringBuilder(length);
        block3: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '!': 
                case '#': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '_': 
                case '`': 
                case '{': 
                case '}': {
                    buffer.append('\\');
                    buffer.append(c);
                    continue block3;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    private void ensureBeginningOfLine() {
        if (!this.isWriterAtStartOfNewLine) {
            this.write(EOL);
        }
    }
}

