/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;

public class LeftOrRightValue<V1, V2> {
    private final V1 leftValue;
    private final V2 rightValue;

    private LeftOrRightValue(V1 leftValue, V2 rightValue) {
        if (leftValue != null && rightValue != null) {
            throw new IllegalArgumentException("Only one value cannot be null");
        }
        if (leftValue == null && rightValue == null) {
            throw new NullPointerException("Only one value can be null");
        }
        this.leftValue = leftValue;
        this.rightValue = rightValue;
    }

    public static <V1, V2> LeftOrRightValue<V1, V2> makeLeftValue(V1 leftValue) {
        return new LeftOrRightValue<V1, Object>(leftValue, null);
    }

    public static <V1, V2> LeftOrRightValue<V1, V2> makeRightValue(V2 rightValue) {
        return new LeftOrRightValue<Object, V2>(null, rightValue);
    }

    public static <V> LeftOrRightValue make(boolean isLeftSide, V value) {
        Objects.requireNonNull(value, "value is null");
        return isLeftSide ? LeftOrRightValue.makeLeftValue(value) : LeftOrRightValue.makeRightValue(value);
    }

    public V1 getLeftValue() {
        return this.leftValue;
    }

    public V2 getRightValue() {
        return this.rightValue;
    }

    public String toString() {
        return "<" + (this.leftValue != null ? "left," + this.leftValue : "right," + this.rightValue) + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeftOrRightValue that = (LeftOrRightValue)o;
        return Objects.equals(this.leftValue, that.leftValue) && Objects.equals(this.rightValue, that.rightValue);
    }

    public int hashCode() {
        return Objects.hash(this.leftValue, this.rightValue);
    }
}

