/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;

public abstract class AbstractTracingProvider {
    protected static String getSpanIdHeader() {
        return AbstractTracingProvider.getHeaderOrDefault("org.apache.cxf.tracing.header.span_id", "X-Span-Id");
    }

    private static String getHeaderOrDefault(String property, String fallback) {
        String name;
        Object header;
        Message message = PhaseInterceptorChain.getCurrentMessage();
        if (message != null && (header = message.getContextualProperty(property)) instanceof String && !StringUtils.isEmpty((String)(name = (String)header))) {
            return name;
        }
        return fallback;
    }

    protected String buildSpanDescription(String path, String method) {
        if (StringUtils.isEmpty((String)method)) {
            return path;
        }
        return method + " " + path;
    }

    private static String safeGet(Message message, String key) {
        if (!message.containsKey((Object)key)) {
            return null;
        }
        Object value = message.get((Object)key);
        return value instanceof String ? value.toString() : null;
    }

    private static String getUriAsString(Message message) {
        String query;
        String uri = AbstractTracingProvider.safeGet(message, "org.apache.cxf.request.url");
        if (uri == null) {
            String address = AbstractTracingProvider.safeGet(message, Message.ENDPOINT_ADDRESS);
            uri = AbstractTracingProvider.safeGet(message, "org.apache.cxf.request.uri");
            if (uri != null && uri.startsWith("/")) {
                if (address != null && !address.startsWith(uri)) {
                    if (address.endsWith("/") && address.length() > 1) {
                        address = address.substring(0, address.length());
                    }
                    uri = address + uri;
                }
            } else {
                uri = address;
            }
        }
        if ((query = AbstractTracingProvider.safeGet(message, Message.QUERY_STRING)) != null) {
            return uri + "?" + query;
        }
        return uri;
    }

    protected static URI getUri(Message message) {
        try {
            String uriSt = AbstractTracingProvider.getUriAsString(message);
            return uriSt != null ? new URI(uriSt) : new URI("");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected static class TraceScopeHolder<T>
    implements Serializable {
        private static final long serialVersionUID = -5985783659818936359L;
        private final T scope;
        private final boolean detached;

        public TraceScopeHolder(T scope, boolean detached) {
            this.scope = scope;
            this.detached = detached;
        }

        public T getScope() {
            return this.scope;
        }

        public boolean isDetached() {
            return this.detached;
        }
    }
}

