/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public abstract class SystemAction
extends SharedClassObject
implements Action,
HelpCtx.Provider {
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_ICON = "icon";
    private static final String PROP_ICON_TEXTUAL = "iconTextual";
    private static ImageIcon BLANK_ICON = null;
    private static final Set relativeIconResourceClasses = new HashSet(200);
    private static final long serialVersionUID = -8361232596876856810L;

    private static ImageIcon getBlankIcon() {
        if (BLANK_ICON == null) {
            BLANK_ICON = new ImageIcon(Utilities.loadImage("org/openide/resources/actions/empty.gif", true));
        }
        return BLANK_ICON;
    }

    public static SystemAction get(Class clazz) {
        return (SystemAction)SystemAction.findObject(clazz, true);
    }

    public abstract String getName();

    public abstract HelpCtx getHelpCtx();

    public boolean isEnabled() {
        return this.getProperty(PROP_ENABLED).equals(Boolean.TRUE);
    }

    public void setEnabled(boolean bl) {
        this.putProperty(PROP_ENABLED, bl ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public final void putValue(String string, Object object) {
        this.putProperty(string, object, true);
    }

    public final Object getValue(String string) {
        if ("iconBase".equals(string)) {
            return this.iconResource();
        }
        Object object = this.getProperty(string);
        if (object == null) {
            if ("Name".equals(string)) {
                object = this.getName();
            } else if ("SmallIcon".equals(string)) {
                object = this.getIcon();
            }
        }
        return object;
    }

    public abstract void actionPerformed(ActionEvent var1);

    protected void initialize() {
        this.putProperty(PROP_ENABLED, Boolean.TRUE);
        super.initialize();
    }

    protected boolean clearSharedData() {
        return false;
    }

    public final void setIcon(Icon icon) {
        this.putProperty(PROP_ICON, icon, true);
        this.putProperty(PROP_ICON_TEXTUAL, icon);
    }

    public final Icon getIcon() {
        return this.getIcon(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Icon getIcon(boolean bl) {
        Object object = this.getLock();
        synchronized (object) {
            Icon icon = (Icon)this.getProperty(bl ? PROP_ICON_TEXTUAL : PROP_ICON);
            if (icon == null) {
                String string = this.iconResource();
                if (string != null) {
                    if (string.indexOf(47) == -1) {
                        String string2 = this.getClass().getName();
                        URL uRL = this.getClass().getResource(string);
                        if (uRL == null) throw new IllegalStateException("No such icon from " + string2 + ": " + string);
                        icon = new ImageIcon(uRL);
                        if (relativeIconResourceClasses.add(string2)) {
                            ErrorManager.getDefault().log(16, "Deprecated relative path in " + string2 + ".iconResource (cf. #20072)");
                        }
                    } else {
                        Image image = Utilities.loadImage(string, true);
                        if (image != null) {
                            icon = new ImageIcon(image);
                        } else {
                            URL uRL = this.getClass().getResource(string);
                            String string3 = this.getClass().getName();
                            if (uRL == null) throw new IllegalStateException("No such icon from " + string3 + ": " + string);
                            icon = new ImageIcon(uRL);
                            if (relativeIconResourceClasses.add(string3)) {
                                ErrorManager.getDefault().log(16, "Deprecated relative path in " + string3 + ".iconResource (cf. #26887)");
                            }
                        }
                    }
                    this.putProperty(PROP_ICON, icon);
                    this.putProperty(PROP_ICON_TEXTUAL, icon);
                } else if (bl) {
                    int n;
                    String string4 = this.getName();
                    if (string4.endsWith("...")) {
                        string4 = string4.substring(0, string4.length() - 3);
                    }
                    if ((n = (string4 = string4.trim()).indexOf(38)) != -1) {
                        string4 = new StringBuffer(string4).deleteCharAt(n).toString();
                    }
                    icon = new ComponentIcon(new JLabel(string4));
                    this.putProperty(PROP_ICON_TEXTUAL, icon);
                } else {
                    icon = SystemAction.getBlankIcon();
                    this.putProperty(PROP_ICON, icon);
                }
            }
            return icon;
        }
    }

    protected String iconResource() {
        return null;
    }

    public static JToolBar createToolbarPresenter(SystemAction[] systemActionArray) {
        JToolBar jToolBar = new JToolBar();
        int n = systemActionArray.length;
        for (int i = 0; i < n; ++i) {
            if (systemActionArray[i] == null) {
                jToolBar.addSeparator();
                continue;
            }
            if (!(systemActionArray[i] instanceof Presenter.Toolbar)) continue;
            jToolBar.add(((Presenter.Toolbar)((Object)systemActionArray[i])).getToolbarPresenter());
        }
        return jToolBar;
    }

    public static SystemAction[] linkActions(SystemAction[] systemActionArray, SystemAction[] systemActionArray2) {
        Vector<SystemAction> vector = new Vector<SystemAction>(Arrays.asList(systemActionArray));
        vector.addAll(Arrays.asList(systemActionArray2));
        return vector.toArray(systemActionArray);
    }

    public static JPopupMenu createPopupMenu(SystemAction[] systemActionArray) {
        return Utilities.actionsToPopup((Action[])systemActionArray, Utilities.actionsGlobalContext());
    }

    private static class ComponentIcon
    extends ImageIcon {
        private JComponent comp;
        private BufferedImage image;

        public ComponentIcon(JComponent jComponent) {
            if (jComponent.getParent() != null) {
                throw new IllegalArgumentException();
            }
            this.comp = jComponent;
            Dimension dimension = jComponent.getPreferredSize();
            jComponent.setSize(Math.max(dimension.width, 16), Math.max(dimension.height, 16));
        }

        protected void loadImage(Image image) {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.comp.setBackground(component.getBackground());
            this.comp.setForeground(component.getForeground());
            Graphics graphics2 = graphics.create(n, n2, this.getIconWidth(), this.getIconHeight());
            this.comp.paint(graphics2);
        }

        public int getIconWidth() {
            return this.comp.getWidth();
        }

        public int getIconHeight() {
            return this.comp.getHeight();
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                this.comp.setForeground(Color.black);
                this.comp.paint(this.image.getGraphics());
            }
            return this.image;
        }
    }
}

