/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.spring.metafacades;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.andromda.cartridges.spring.SpringProfile;
import org.andromda.cartridges.spring.metafacades.SpringGlobals;
import org.andromda.cartridges.spring.metafacades.SpringServiceOperationLogic;
import org.andromda.metafacades.uml.MetafacadeUtils;
import org.andromda.metafacades.uml.ParameterFacade;
import org.andromda.metafacades.uml.UMLProfile;
import org.andromda.utils.StringUtilsHelper;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class SpringServiceOperationLogicImpl
extends SpringServiceOperationLogic {
    private static final long serialVersionUID = 34L;
    private static final String SERVICE_OPERATION_TRANSACTION_TYPE = "serviceOperationTransactionType";
    private static final String EJB_SERVICE_OPERATION_TRANSACTION_TYPE = "ejbServiceOperationTransactionType";
    private static final String MESSAGE_LISTENER_CONTAINER_SUFFIX = "ListenerContainer";

    public SpringServiceOperationLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected boolean handleIsWebserviceExposed() {
        return this.hasStereotype(UMLProfile.STEREOTYPE_WEBSERVICE_OPERATION);
    }

    @Override
    protected String handleGetImplementationName() {
        return this.getImplementationOperationName(StringUtils.capitalize((String)this.getName()));
    }

    @Override
    protected String handleGetImplementationSignature() {
        String signature = null;
        signature = this.isIncomingMessageOperation() ? this.getIncomingMessageImplementationSignature() : (this.isOutgoingMessageOperation() ? this.getOutgoingMessageImplementationSignature() : this.getImplementationOperationName(StringUtils.capitalize((String)this.getSignature())));
        return signature;
    }

    @Override
    public String getCall() {
        String call = null;
        call = this.isIncomingMessageOperation() && this.getArguments().isEmpty() ? this.getName() + "(message)" : super.getCall();
        return call;
    }

    @Override
    public String getSignature(String modifier) {
        String signature = null;
        signature = this.isIncomingMessageOperation() && this.getArguments().isEmpty() ? this.getIncomingMessageSignature(modifier) : super.getSignature(modifier);
        return signature;
    }

    @Override
    public String getSignature(boolean withArgumentNames) {
        String signature = null;
        signature = this.isIncomingMessageOperation() && this.getArguments().isEmpty() ? this.getIncomingMessageSignature(null) : super.getSignature(withArgumentNames);
        return signature;
    }

    @Override
    public String getSignature() {
        return this.getSignature(true);
    }

    @Override
    protected String handleGetImplementationCall() {
        return this.getImplementationOperationName(StringUtils.capitalize((String)this.getCall()));
    }

    private String getImplementationOperationName(String replacement) {
        return StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("implementationOperationNamePattern"))).replaceAll("\\{0\\}", replacement);
    }

    @Override
    public String handleGetTransactionType() {
        String transactionType = (String)this.findTaggedValue(SpringProfile.TAGGEDVALUE_TRANSACTION_TYPE);
        if (StringUtils.isBlank((String)transactionType)) {
            transactionType = (String)this.getOwner().findTaggedValue(SpringProfile.TAGGEDVALUE_TRANSACTION_TYPE);
        }
        if (StringUtils.isBlank((String)transactionType)) {
            transactionType = String.valueOf(this.getConfiguredProperty(SERVICE_OPERATION_TRANSACTION_TYPE));
        }
        return transactionType;
    }

    @Override
    protected String handleGetEjbTransactionType() {
        String transactionType = (String)this.findTaggedValue(SpringProfile.TAGGEDVALUE_EJB_TRANSACTION_TYPE);
        if (StringUtils.isBlank((String)transactionType)) {
            transactionType = (String)this.getOwner().findTaggedValue(SpringProfile.TAGGEDVALUE_EJB_TRANSACTION_TYPE);
        }
        if (StringUtils.isBlank((String)transactionType)) {
            transactionType = String.valueOf(this.getConfiguredProperty(EJB_SERVICE_OPERATION_TRANSACTION_TYPE));
        }
        return transactionType;
    }

    @Override
    protected String handleGetThrowsClause() {
        StringBuilder throwsClause = null;
        if (this.isExceptionsPresent()) {
            throwsClause = new StringBuilder(this.getExceptionList());
        }
        if (throwsClause != null) {
            throwsClause.insert(0, "throws ");
        }
        return throwsClause != null ? throwsClause.toString() : null;
    }

    @Override
    protected String handleGetThrowsClause(String initialExceptions) {
        StringBuilder throwsClause = new StringBuilder(initialExceptions);
        if (this.getThrowsClause() != null) {
            throwsClause.insert(0, ", ");
            throwsClause.insert(0, this.getThrowsClause());
        } else {
            throwsClause.insert(0, "throws ");
        }
        return throwsClause.toString();
    }

    @Override
    protected String handleGetOutgoingMessageImplementationCall() {
        return this.getMessageImplementationCall("session");
    }

    private String getMessageImplementationCall(String firstArgument) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(StringUtils.capitalize((String)this.getName()));
        buffer.append('(');
        boolean outgoingMessageOperation = this.isOutgoingMessageOperation();
        if (outgoingMessageOperation || this.isIncomingMessageOperation() && this.getArguments().isEmpty()) {
            buffer.append(firstArgument);
        }
        String argumentNames = this.getArgumentNames();
        if (outgoingMessageOperation && StringUtils.isNotBlank((String)argumentNames)) {
            buffer.append(", ");
        }
        if (StringUtils.isNotBlank((String)argumentNames)) {
            buffer.append(argumentNames);
        }
        buffer.append(')');
        return this.getImplementationOperationName(buffer.toString());
    }

    @Override
    protected String handleGetOutgoingMessageImplementationSignature() {
        return this.getMessagingImplementationSignature("javax.jms.Session session");
    }

    private String getMessagingImplementationSignature(String firstArgument) {
        return this.getMessagingOperationSignature(this.getImplementationName(), firstArgument, null);
    }

    private String getIncomingMessageSignature(String modifier) {
        return this.getMessagingOperationSignature(this.getName(), "javax.jms.Message message", modifier);
    }

    private String getMessagingOperationSignature(String operationName, String firstArgument, String modifier) {
        StringBuilder signature = new StringBuilder(operationName);
        signature.append('(');
        if (StringUtils.isNotBlank((String)modifier)) {
            signature.append(modifier).append(' ');
        }
        Collection<ParameterFacade> arguments = this.getArguments();
        boolean outgoingMessageOperation = this.isOutgoingMessageOperation();
        if (outgoingMessageOperation || this.isIncomingMessageOperation() && arguments.isEmpty()) {
            signature.append(firstArgument);
        }
        String argumentList = MetafacadeUtils.getTypedArgumentList(this.getArguments(), (boolean)true, (String)modifier);
        if (outgoingMessageOperation && StringUtils.isNotBlank((String)argumentList)) {
            signature.append(", ");
        }
        if (StringUtils.isNotBlank((String)argumentList)) {
            signature.append(argumentList);
        }
        signature.append(')');
        return signature.toString();
    }

    @Override
    protected String handleGetIncomingMessageImplementationCall() {
        return this.getMessageImplementationCall("message");
    }

    @Override
    protected String handleGetIncomingMessageImplementationSignature() {
        return this.getMessagingImplementationSignature("javax.jms.Message message");
    }

    @Override
    protected String handleGetImplementationReturnTypeName() {
        String returnTypeName = null;
        returnTypeName = this.isOutgoingMessageOperation() ? "javax.jms.Message" : this.getGetterSetterReturnTypeName();
        return returnTypeName;
    }

    @Override
    protected String handleGetFullyQualifiedMessageListenerName() {
        StringBuilder name = new StringBuilder();
        String packageName = this.getPackageName();
        if (StringUtils.isNotBlank((String)packageName)) {
            name.append(packageName).append('.');
        }
        name.append(this.getMessageListenerName());
        return name.toString();
    }

    @Override
    protected String handleGetMessageListenerName() {
        return this.getOwner().getName() + StringUtilsHelper.upperCamelCaseName((String)this.getName());
    }

    @Override
    protected String handleGetMessageListenerBeanName() {
        return StringUtils.uncapitalize((String)this.getMessageListenerName());
    }

    @Override
    protected String handleGetMessageListenerContainerReferenceName() {
        return this.getName() + MESSAGE_LISTENER_CONTAINER_SUFFIX;
    }

    @Override
    protected String handleGetMessageListenerContainerBeanName() {
        return this.getMessageListenerBeanName() + MESSAGE_LISTENER_CONTAINER_SUFFIX;
    }

    @Override
    protected String handleGetSessionAcknowledgeMode() {
        String mode = null;
        Object value = this.findTaggedValue(SpringProfile.TAGGEDVALUEVALUE_MESSAGING_SESSION_ACKNOWLEDGE_MODE);
        if (value != null) {
            mode = ObjectUtils.toString((Object)value);
        }
        return mode;
    }

    @Override
    protected boolean handleIsOptimizeAcknowledge() {
        return BooleanUtils.toBoolean((String)ObjectUtils.toString((Object)this.findTaggedValue(SpringProfile.TAGGEDVALUEVALUE_ACTIVEMQ_OPTIMIZE_ACKNOWLEDGE)));
    }

    @Override
    protected boolean handleIsNullMessageConverterRequired() {
        boolean result = false;
        Collection<ParameterFacade> arguments = this.getArguments();
        if (arguments != null && arguments.size() == 1) {
            ParameterFacade parameter = arguments.iterator().next();
            String parameterType = parameter.getType().getFullyQualifiedName();
            HashSet jmsMessageTypes = new HashSet();
            Collections.addAll(jmsMessageTypes, SpringGlobals.jmsMessageTypes);
            result = jmsMessageTypes.contains(parameterType);
        }
        return result;
    }

    @Override
    protected boolean handleIsInitMethod() {
        return this.hasStereotype(SpringProfile.STEREOTYPE_POST_CONSTRUCT_METHOD);
    }

    @Override
    protected boolean handleIsDestroyMethod() {
        return this.hasStereotype(SpringProfile.STEREOTYPE_PRE_DESTROY_METHOD);
    }
}

