/*
 * Decompiled with CFR 0.152.
 */
package kr.motd.maven.os;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.inject.Inject;
import kr.motd.maven.os.DetectMojo;
import kr.motd.maven.os.DetectionException;
import kr.motd.maven.os.Detector;
import kr.motd.maven.os.RepositorySessionInjector;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.InterpolationFilterReader;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="detect-os")
public class DetectExtension
extends AbstractMavenLifecycleParticipant {
    private final Logger logger;
    private final Detector detector;

    @Inject
    public DetectExtension(final Logger logger) {
        this.logger = logger;
        this.detector = new Detector(){

            @Override
            protected void log(String message) {
                logger.info(message);
            }

            @Override
            protected void logProperty(String name, String value) {
                if (logger.isInfoEnabled()) {
                    logger.info(name + ": " + value);
                }
            }
        };
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        Properties sessionProps = new Properties();
        sessionProps.putAll((Map<?, ?>)session.getSystemProperties());
        sessionProps.putAll((Map<?, ?>)session.getUserProperties());
        try {
            this.detector.detect(sessionProps, DetectExtension.getClassifierWithLikes(session));
        }
        catch (DetectionException e) {
            throw new MavenExecutionException(e.getMessage(), session.getCurrentProject().getFile());
        }
        LinkedHashMap<String, String> dict = new LinkedHashMap<String, String>();
        dict.put("os.detected.name", sessionProps.getProperty("os.detected.name"));
        dict.put("os.detected.arch", sessionProps.getProperty("os.detected.arch"));
        dict.put("os.detected.bitness", sessionProps.getProperty("os.detected.bitness"));
        dict.put("os.detected.classifier", sessionProps.getProperty("os.detected.classifier"));
        for (Map.Entry<Object, Object> entry : sessionProps.entrySet()) {
            if (!entry.getKey().toString().startsWith("os.detected.release")) continue;
            dict.put(entry.getKey().toString(), entry.getValue().toString());
        }
        this.injectSession(session, dict);
        for (MavenProject p : session.getProjects()) {
            DetectExtension.interpolate(dict, p);
        }
    }

    private static List<String> getClassifierWithLikes(MavenSession session) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)session.getUserProperties());
        props.putAll((Map<?, ?>)session.getCurrentProject().getProperties());
        return DetectMojo.getClassifierWithLikes(props.getProperty("os.detection.classifierWithLikes"));
    }

    private void injectSession(MavenSession session, Map<String, String> dict) {
        Properties sessionExecProps = session.getSystemProperties();
        sessionExecProps.setProperty("os.detected.name", String.valueOf(dict.get("os.detected.name")));
        sessionExecProps.setProperty("os.detected.arch", String.valueOf(dict.get("os.detected.arch")));
        sessionExecProps.setProperty("os.detected.classifier", String.valueOf(dict.get("os.detected.classifier")));
        for (Map.Entry<String, String> entry : dict.entrySet()) {
            if (!entry.getKey().startsWith("os.detected.release")) continue;
            sessionExecProps.setProperty(entry.getKey(), String.valueOf(entry.getValue()));
        }
        for (StackTraceElement e : new Exception().getStackTrace()) {
            if (!String.valueOf(e.getClassName()).startsWith("org.jetbrains.idea.maven")) continue;
            return;
        }
        RepositorySessionInjector.injectRepositorySession(this.logger, session, dict);
    }

    private static void interpolate(Map<String, String> dict, MavenProject p) {
        if (p == null) {
            return;
        }
        DetectExtension.interpolate(dict, p.getParent());
        DetectExtension.interpolate(dict, (ModelBase)p.getModel());
        for (ModelBase model : p.getActiveProfiles()) {
            DetectExtension.interpolate(dict, model);
        }
    }

    private static void interpolate(Map<String, String> dict, ModelBase model) {
        Build build;
        Properties modelProps = model.getProperties();
        for (Map.Entry<String, String> e : dict.entrySet()) {
            modelProps.setProperty(e.getKey(), String.valueOf(e.getValue()));
        }
        DetectExtension.interpolate(dict, model.getDependencies());
        DependencyManagement depMgmt = model.getDependencyManagement();
        if (depMgmt != null) {
            DetectExtension.interpolate(dict, depMgmt.getDependencies());
        }
        if (model instanceof Model && (build = ((Model)model).getBuild()) != null) {
            for (Plugin bp : build.getPlugins()) {
                DetectExtension.interpolate(dict, bp.getDependencies());
            }
            if (build.getPluginManagement() != null) {
                for (Plugin bp : build.getPluginManagement().getPlugins()) {
                    DetectExtension.interpolate(dict, bp.getDependencies());
                }
            }
        }
    }

    private static void interpolate(Map<String, String> dict, Iterable<Dependency> dependencies) {
        if (dependencies == null) {
            return;
        }
        for (Dependency d : dependencies) {
            d.setGroupId(DetectExtension.interpolate(dict, d.getGroupId()));
            d.setArtifactId(DetectExtension.interpolate(dict, d.getArtifactId()));
            d.setVersion(DetectExtension.interpolate(dict, d.getVersion()));
            d.setClassifier(DetectExtension.interpolate(dict, d.getClassifier()));
            d.setSystemPath(DetectExtension.interpolate(dict, d.getSystemPath()));
            for (Exclusion e : d.getExclusions()) {
                e.setGroupId(DetectExtension.interpolate(dict, e.getGroupId()));
                e.setArtifactId(DetectExtension.interpolate(dict, e.getArtifactId()));
            }
        }
    }

    @Nullable
    private static String interpolate(Map<String, String> dict, String value) {
        if (value == null) {
            return null;
        }
        while (value.contains("${")) {
            InterpolationFilterReader reader = new InterpolationFilterReader((Reader)new StringReader(value), dict);
            StringWriter writer = new StringWriter(value.length());
            while (true) {
                int ch;
                try {
                    ch = reader.read();
                }
                catch (IOException e) {
                    throw (Error)new Error().initCause(e);
                }
                if (ch == -1) break;
                writer.write(ch);
            }
            String newValue = writer.toString();
            if (value.equals(newValue)) break;
            value = newValue;
        }
        return value;
    }
}

