/*
 * Decompiled with CFR 0.152.
 */
package brave.messaging;

import brave.Tracing;
import brave.internal.Nullable;
import brave.messaging.MessagingRequest;
import brave.propagation.Propagation;
import brave.sampler.SamplerFunction;
import brave.sampler.SamplerFunctions;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicReference;

public class MessagingTracing
implements Closeable {
    static final AtomicReference<MessagingTracing> CURRENT = new AtomicReference();
    final Tracing tracing;
    final SamplerFunction<MessagingRequest> producerSampler;
    final SamplerFunction<MessagingRequest> consumerSampler;
    final Propagation<String> propagation;

    public static MessagingTracing create(Tracing tracing) {
        return MessagingTracing.newBuilder(tracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return new Builder(tracing);
    }

    public Tracing tracing() {
        return this.tracing;
    }

    public SamplerFunction<MessagingRequest> producerSampler() {
        return this.producerSampler;
    }

    public SamplerFunction<MessagingRequest> consumerSampler() {
        return this.consumerSampler;
    }

    public Propagation<String> propagation() {
        return this.propagation;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    MessagingTracing(Builder builder) {
        this.tracing = builder.tracing;
        this.producerSampler = builder.producerSampler;
        this.consumerSampler = builder.consumerSampler;
        this.propagation = builder.propagation;
        CURRENT.compareAndSet(null, this);
    }

    @Nullable
    public static MessagingTracing current() {
        return CURRENT.get();
    }

    @Override
    public void close() {
        CURRENT.compareAndSet(this, null);
    }

    public static final class Builder {
        Tracing tracing;
        SamplerFunction<MessagingRequest> producerSampler;
        SamplerFunction<MessagingRequest> consumerSampler;
        Propagation<String> propagation;

        Builder(Tracing tracing) {
            if (tracing == null) {
                throw new NullPointerException("tracing == null");
            }
            this.tracing = tracing;
            this.propagation = tracing.propagation();
            this.producerSampler = SamplerFunctions.deferDecision();
            this.consumerSampler = SamplerFunctions.deferDecision();
        }

        Builder(MessagingTracing source) {
            this.tracing = source.tracing;
            this.producerSampler = source.producerSampler;
            this.consumerSampler = source.consumerSampler;
            this.propagation = source.propagation;
        }

        public Builder tracing(Tracing tracing) {
            if (tracing == null) {
                throw new NullPointerException("tracing == null");
            }
            this.tracing = tracing;
            return this;
        }

        public Builder producerSampler(SamplerFunction<MessagingRequest> producerSampler) {
            if (producerSampler == null) {
                throw new NullPointerException("producerSampler == null");
            }
            this.producerSampler = producerSampler;
            return this;
        }

        public Builder consumerSampler(SamplerFunction<MessagingRequest> consumerSampler) {
            if (consumerSampler == null) {
                throw new NullPointerException("consumerSampler == null");
            }
            this.consumerSampler = consumerSampler;
            return this;
        }

        public Builder propagation(Propagation<String> propagation) {
            if (propagation == null) {
                throw new NullPointerException("propagation == null");
            }
            this.propagation = propagation;
            return this;
        }

        public MessagingTracing build() {
            return new MessagingTracing(this);
        }
    }
}

