/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser;

import io.ultreia.java4all.lang.Strings;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.i18n.plugin.parser.I18nParseMojoConfiguration;
import org.nuiton.i18n.spi.GetterFile;

public class ParserTask
implements Runnable,
I18nParseMojoConfiguration {
    protected final I18nParseMojoConfiguration configuration;
    protected final FileParser parser;
    protected final File file;
    private long startingTime;
    private long endingTime;

    ParserTask(I18nParseMojoConfiguration configuration, FileParser parser, File file) {
        this.configuration = configuration;
        this.parser = parser;
        this.file = file;
    }

    @Override
    public boolean isVerbose() {
        return this.configuration.isVerbose();
    }

    @Override
    public boolean isSilent() {
        return this.configuration.isSilent();
    }

    @Override
    public boolean isShowTouchedFiles() {
        return this.configuration.isShowTouchedFiles();
    }

    @Override
    public Log getLog() {
        return this.configuration.getLog();
    }

    @Override
    public GetterFile getGetterFile() {
        return this.configuration.getGetterFile();
    }

    @Override
    public void run() {
        this.startingTime = System.nanoTime();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("starting action for %s", this.file));
        }
        try {
            this.parser.parseFile(this.file);
        }
        catch (Exception e) {
            block8: {
                try {
                    if (!this.getLog().isErrorEnabled()) break block8;
                    this.getLog().error((CharSequence)String.format("could not parse file %s", this.file), (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)String.format("ending action for %s", this.file));
                    }
                    this.endingTime = System.nanoTime();
                    throw throwable;
                }
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)String.format("ending action for %s", this.file));
            }
            this.endingTime = System.nanoTime();
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("ending action for %s", this.file));
        }
        this.endingTime = System.nanoTime();
    }

    public String toString() {
        return super.toString() + " - " + this.file;
    }

    protected File getFile() {
        return this.file;
    }

    private long getDelay() {
        return this.endingTime - this.startingTime;
    }

    private void destroy() {
        this.parser.destroy();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void registerResult(List<File> treatedFiles, List<File> touchedFiles, GetterFile result) {
        try {
            String delay;
            treatedFiles.add(this.file);
            if (this.getLog().isDebugEnabled()) {
                delay = Strings.convertTime((long)this.getDelay());
                this.getLog().debug((CharSequence)String.format("[%d] %s in %s", treatedFiles.size(), this.file, delay));
            }
            if (this.parser.isTouched()) {
                touchedFiles.add(this.file);
                if (this.isShowTouchedFiles()) {
                    this.getLog().info((CharSequence)("touch " + this.file));
                }
                if (this.isVerbose()) {
                    delay = Strings.convertTime((long)this.getDelay());
                    this.getLog().info((CharSequence)String.format("[%d] file(s) touched %s in %s", treatedFiles.size(), this.file, delay));
                }
                result.addKeys(this.parser.getResult());
            }
        }
        finally {
            this.destroy();
        }
    }
}

