/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.streams.stages;

import io.reactivex.Flowable;
import io.smallrye.reactive.streams.Engine;
import io.smallrye.reactive.streams.operators.ProcessingStage;
import io.smallrye.reactive.streams.operators.ProcessingStageFactory;
import io.smallrye.reactive.streams.utils.Casts;
import io.smallrye.reactive.streams.utils.DelegatingSubscriber;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.streams.operators.spi.Graph;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;

public class FlatMapStageFactory
implements ProcessingStageFactory<Stage.FlatMap> {
    @Override
    public <I, O> ProcessingStage<I, O> create(Engine engine, Stage.FlatMap stage) {
        Function mapper = Casts.cast(stage.getMapper());
        return new FlatMapStage(engine, mapper);
    }

    private static class FlatMapStage<I, O>
    implements ProcessingStage<I, O> {
        private final Engine engine;
        private final Function<I, Graph> mapper;

        private FlatMapStage(Engine engine, Function<I, Graph> mapper) {
            this.mapper = Objects.requireNonNull(mapper);
            this.engine = engine;
        }

        @Override
        public Flowable<O> apply(Flowable<I> source) {
            return source.concatMap(item -> {
                Graph graph = this.mapper.apply(item);
                Flowable publisher = Flowable.fromPublisher(Objects.requireNonNull(this.engine.buildPublisher(Objects.requireNonNull(graph))));
                return delegate -> {
                    DelegatingSubscriber facade = new DelegatingSubscriber(delegate);
                    publisher.subscribe(facade);
                };
            });
        }
    }
}

