/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.GroupedMulti;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.helpers.queues.Queues;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public final class MultiGroupByOp<T, K, V>
extends AbstractMultiOperator<T, GroupedMulti<K, V>> {
    private final Function<? super T, ? extends K> keySelector;
    private final Function<? super T, ? extends V> valueSelector;
    private final long prefetch;

    public MultiGroupByOp(Multi<T> upstream, Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, long prefetch) {
        super(upstream);
        this.keySelector = keySelector;
        this.valueSelector = valueSelector;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribe(MultiSubscriber<? super GroupedMulti<K, V>> downstream) {
        Objects.requireNonNull(downstream, "The subscriber must not be `null`");
        ConcurrentHashMap groups = new ConcurrentHashMap();
        MultiGroupByProcessor<? super T, ? extends K, ? extends V> processor = new MultiGroupByProcessor<T, K, V>(downstream, this.keySelector, this.valueSelector, groups, this.prefetch);
        this.upstream.subscribe().withSubscriber(processor);
    }

    public static final class MultiGroupByProcessor<T, K, V>
    extends MultiOperatorProcessor<T, GroupedMulti<K, V>> {
        private final Function<? super T, ? extends K> keySelector;
        private final Function<? super T, ? extends V> valueSelector;
        private final long prefetch;
        private final Map<Object, GroupedUnicast<K, V>> groups;
        private final Queue<GroupedMulti<K, V>> queue;
        private static final Object NO_KEY = new Object();
        private final AtomicBoolean cancelled = new AtomicBoolean();
        private final AtomicLong requested = new AtomicLong();
        private final AtomicInteger groupCount = new AtomicInteger(1);
        private final AtomicInteger wip = new AtomicInteger();
        Throwable failure;
        volatile boolean finished;
        boolean done;

        public MultiGroupByProcessor(MultiSubscriber<? super GroupedMulti<K, V>> downstream, Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, Map<Object, GroupedUnicast<K, V>> groups, long prefetch) {
            super(downstream);
            this.keySelector = keySelector;
            this.valueSelector = valueSelector;
            this.prefetch = prefetch;
            this.groups = groups;
            this.queue = Queues.unbounded(Infrastructure.getBufferSizeS()).get();
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (this.compareAndSetUpstreamSubscription(null, subscription)) {
                this.downstream.onSubscribe(this);
                subscription.request(this.prefetch);
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void onItem(T item) {
            V value;
            K key;
            if (this.isDone()) {
                return;
            }
            try {
                key = this.keySelector.apply(item);
            }
            catch (Throwable ex) {
                super.onFailure(ex);
                super.cancel();
                return;
            }
            boolean newGroup = false;
            Object mapKey = key != null ? key : NO_KEY;
            GroupedUnicast<K, Object> group = this.groups.get(mapKey);
            if (group == null) {
                if (this.isCancelled()) {
                    return;
                }
                group = GroupedUnicast.createWith(key, this);
                this.groups.put(mapKey, group);
                this.groupCount.getAndIncrement();
                newGroup = true;
            }
            try {
                value = this.valueSelector.apply(item);
                if (value == null) {
                    throw new NullPointerException("The selector returned `null`");
                }
            }
            catch (Throwable ex) {
                super.onFailure(ex);
                super.cancel();
                return;
            }
            group.onItem(value);
            if (newGroup) {
                this.queue.offer(group);
                this.drain();
            }
        }

        @Override
        public void onFailure(Throwable throwable) {
            Flow.Subscription subscription = this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED);
            if (subscription != Subscriptions.CANCELLED) {
                this.done = true;
                this.groups.values().forEach(group -> group.onFailure(throwable));
                this.groups.clear();
                this.failure = throwable;
                this.finished = true;
                this.drain();
            } else {
                Infrastructure.handleDroppedException(throwable);
            }
        }

        @Override
        public void onCompletion() {
            Flow.Subscription subscription = this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED);
            if (subscription != Subscriptions.CANCELLED) {
                this.done = true;
                this.groups.values().forEach(GroupedUnicast::onComplete);
                this.groups.clear();
                this.finished = true;
                this.drain();
            }
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
                this.drain();
            } else {
                this.onFailure(Subscriptions.getInvalidRequestException());
            }
        }

        @Override
        public void cancel() {
            if (this.cancelled.compareAndSet(false, true) && this.groupCount.decrementAndGet() == 0) {
                this.cancelUpstream();
            }
        }

        public void cancel(K key) {
            Object mapKey = key != null ? key : NO_KEY;
            this.groups.remove(mapKey);
            if (this.groupCount.decrementAndGet() == 0) {
                this.cancelUpstream();
                if (this.wip.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        private void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Queue<GroupedMulti<K, V>> q = this.queue;
            do {
                long emitted;
                long requests = this.requested.get();
                for (emitted = 0L; emitted != requests; ++emitted) {
                    boolean hasNoMoreGroup;
                    boolean isDone = this.finished;
                    GroupedMulti<K, V> t = q.poll();
                    boolean bl = hasNoMoreGroup = t == null;
                    if (this.isDoneOrCancelled(isDone, hasNoMoreGroup, q)) {
                        return;
                    }
                    if (hasNoMoreGroup) break;
                    this.downstream.onItem(t);
                }
                if (emitted == requests && this.isDoneOrCancelled(this.finished, q.isEmpty(), q)) {
                    return;
                }
                if (emitted == 0L) continue;
                if (requests != Long.MAX_VALUE) {
                    this.requested.addAndGet(-emitted);
                }
                super.request(emitted);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        boolean isDoneOrCancelled(boolean d, boolean empty, Queue<?> q) {
            if (this.isCancelled()) {
                q.clear();
                return true;
            }
            if (d) {
                Throwable ex = this.failure;
                if (ex != null) {
                    q.clear();
                    this.downstream.onFailure(ex);
                    return true;
                }
                if (empty) {
                    this.downstream.onCompletion();
                    return true;
                }
            }
            return false;
        }
    }

    private static final class State<T, K>
    implements Flow.Subscription,
    Flow.Publisher<T> {
        private final AtomicReference<Flow.Subscriber<? super T>> downstream = new AtomicReference();
        private final AtomicBoolean cancelled = new AtomicBoolean();
        private final AtomicLong requested = new AtomicLong();
        private final AtomicBoolean done = new AtomicBoolean();
        private final AtomicInteger wip = new AtomicInteger();
        private final K key;
        private final Queue<T> queue;
        private final MultiGroupByProcessor<?, K, T> parent;
        private Throwable failure;

        State(MultiGroupByProcessor<?, K, T> parent, K key) {
            this.parent = parent;
            this.queue = Queues.unbounded(Infrastructure.getBufferSizeS()).get();
            this.key = key;
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
                this.drain();
            } else {
                this.onFailure(Subscriptions.getInvalidRequestException());
            }
        }

        @Override
        public void cancel() {
            if (this.cancelled.compareAndSet(false, true)) {
                this.parent.cancel(this.key);
                this.drain();
            }
        }

        @Override
        public void subscribe(Flow.Subscriber<? super T> s) {
            if (this.downstream.compareAndSet(null, s)) {
                s.onSubscribe(this);
                this.drain();
            } else {
                Subscriptions.fail(s, new IllegalStateException("only 1 subscriber allowed"));
            }
        }

        public void onItem(T t) {
            if (!this.done.get()) {
                this.queue.offer(t);
                this.drain();
            }
        }

        public void onFailure(Throwable e) {
            if (this.done.compareAndSet(false, true)) {
                this.failure = e;
                this.drain();
            } else {
                Infrastructure.handleDroppedException(e);
            }
        }

        public void onCompletion() {
            if (this.done.compareAndSet(false, true)) {
                this.drain();
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Queue<T> q = this.queue;
            Flow.Subscriber<T> actual = this.downstream.get();
            while (true) {
                if (actual != null) {
                    long e;
                    long r = this.requested.get();
                    for (e = 0L; e != r; ++e) {
                        boolean empty;
                        boolean isDone = this.done.get();
                        T v = q.poll();
                        boolean bl = empty = v == null;
                        if (this.hasCompleted(isDone, empty, e)) {
                            return;
                        }
                        if (empty) break;
                        actual.onNext(v);
                    }
                    if (e == r && this.hasCompleted(this.done.get(), q.isEmpty(), e)) {
                        return;
                    }
                    if (e != 0L) {
                        if (r != Long.MAX_VALUE) {
                            this.requested.addAndGet(-e);
                        }
                        this.parent.getUpstreamSubscription().request(e);
                    }
                }
                if ((missed = this.wip.addAndGet(-missed)) == 0) break;
                if (actual != null) continue;
                actual = this.downstream.get();
            }
        }

        boolean hasCompleted(boolean isDone, boolean isEmpty, long emitted) {
            if (this.cancelled.get()) {
                while (this.queue.poll() != null) {
                    ++emitted;
                }
                if (emitted != 0L) {
                    this.parent.getUpstreamSubscription().request(emitted);
                }
                return true;
            }
            if (isDone) {
                Throwable e = this.failure;
                if (e != null) {
                    this.queue.clear();
                    this.downstream.get().onError(e);
                    return true;
                }
                if (isEmpty) {
                    this.downstream.get().onComplete();
                    return true;
                }
            }
            return false;
        }
    }

    public static final class GroupedUnicast<K, T>
    extends AbstractMulti<T>
    implements GroupedMulti<K, T> {
        private final State<T, K> downstream;
        private final K key;

        static <T, K> GroupedUnicast<K, T> createWith(K key, MultiGroupByProcessor<?, K, T> parent) {
            State<T, K> state = new State<T, K>(parent, key);
            return new GroupedUnicast<K, T>(key, state);
        }

        private GroupedUnicast(K key, State<T, K> downstream) {
            this.key = key;
            this.downstream = downstream;
        }

        @Override
        public void subscribe(MultiSubscriber<? super T> s) {
            this.downstream.subscribe(s);
        }

        public void onItem(T t) {
            this.downstream.onItem(t);
        }

        public void onFailure(Throwable e) {
            this.downstream.onFailure(e);
        }

        public void onComplete() {
            this.downstream.onCompletion();
        }

        @Override
        public K key() {
            return this.key;
        }
    }
}

