/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.MultiSwitchOnEmpty;
import io.smallrye.mutiny.subscription.MultiEmitter;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public class MultiIfEmpty<T> {
    private final Multi<T> upstream;

    MultiIfEmpty(Multi<T> upstream) {
        this.upstream = upstream;
    }

    public Multi<T> failWith(Throwable failure) {
        ParameterValidation.nonNull(failure, "failure");
        return this.failWith(() -> failure);
    }

    public Multi<T> failWith(Supplier<? extends Throwable> supplier) {
        ParameterValidation.nonNull(supplier, "supplier");
        return this.switchToEmitter(MultiIfEmpty.createMultiFromFailureSupplier(supplier));
    }

    static <T> Consumer<MultiEmitter<? super T>> createMultiFromFailureSupplier(Supplier<? extends Throwable> supplier) {
        return emitter -> {
            Throwable throwable;
            try {
                throwable = (Throwable)supplier.get();
            }
            catch (Throwable e) {
                emitter.fail(e);
                return;
            }
            if (throwable == null) {
                emitter.fail(new NullPointerException("The supplier returned `null`"));
            } else {
                emitter.fail(throwable);
            }
        };
    }

    public Multi<T> fail() {
        return this.failWith(NoSuchElementException::new);
    }

    public Multi<T> switchToEmitter(Consumer<MultiEmitter<? super T>> consumer) {
        ParameterValidation.nonNull(consumer, "consumer");
        return this.switchTo(() -> Multi.createFrom().emitter(consumer));
    }

    public Multi<T> switchTo(Publisher<? extends T> other) {
        return this.switchTo(() -> other);
    }

    public Multi<T> switchTo(Supplier<Publisher<? extends T>> supplier) {
        return Infrastructure.onMultiCreation(new MultiSwitchOnEmpty<T>(this.upstream, ParameterValidation.nonNull(supplier, "supplier")));
    }

    @SafeVarargs
    public final Multi<T> continueWith(T ... items) {
        ParameterValidation.nonNull(items, "items");
        ParameterValidation.doesNotContainNull(items, "items");
        return this.continueWith(() -> Arrays.asList(items));
    }

    public Multi<T> continueWith(Iterable<T> items) {
        ParameterValidation.nonNull(items, "items");
        ParameterValidation.doesNotContainNull(items, "items");
        return this.continueWith(() -> items);
    }

    public Multi<T> continueWith(Supplier<? extends Iterable<? extends T>> supplier) {
        ParameterValidation.nonNull(supplier, "supplier");
        return this.switchTo(() -> MultiIfEmpty.createMultiFromIterableSupplier(supplier));
    }

    static <T> Publisher<? extends T> createMultiFromIterableSupplier(Supplier<? extends Iterable<? extends T>> supplier) {
        Iterable<? extends T> iterable;
        try {
            iterable = supplier.get();
        }
        catch (Throwable e) {
            return Multi.createFrom().failure(e);
        }
        if (iterable == null) {
            return Multi.createFrom().failure(new NullPointerException("The supplier returned `null`"));
        }
        return Multi.createFrom().iterable(iterable);
    }
}

