/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.GroupedMulti;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.groups.MultiGroupIntoLists;
import io.smallrye.mutiny.groups.MultiGroupIntoMultis;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.MultiCollector;
import java.util.function.Function;

public class MultiGroup<T> {
    private final Multi<T> upstream;

    public MultiGroup(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public MultiGroupIntoLists<T> intoLists() {
        return new MultiGroupIntoLists<T>(this.upstream);
    }

    public MultiGroupIntoMultis<T> intoMultis() {
        return new MultiGroupIntoMultis<T>(this.upstream);
    }

    public <K> Multi<GroupedMulti<K, T>> by(Function<? super T, ? extends K> keyMapper) {
        return MultiCollector.groupBy(this.upstream, ParameterValidation.nonNull(keyMapper, "keyMapper"), null);
    }

    public <K, V> Multi<GroupedMulti<K, V>> by(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return MultiCollector.groupBy(this.upstream, ParameterValidation.nonNull(keyMapper, "keyMapper"), ParameterValidation.nonNull(valueMapper, "valueMapper"));
    }
}

