/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.Collection;
import java.util.HashSet;

public final class MultiDistinctOp<T>
extends AbstractMultiOperator<T, T> {
    public MultiDistinctOp(Multi<? extends T> upstream) {
        super(upstream);
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> actual) {
        if (actual == null) {
            throw new NullPointerException("Subscriber cannot be `null`");
        }
        this.upstream.subscribe().withSubscriber(new DistinctProcessor<T>(actual));
    }

    static final class DistinctProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        final Collection<T> collection = new HashSet<T>();

        DistinctProcessor(MultiSubscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onItem(T t) {
            boolean added;
            if (this.isDone()) {
                return;
            }
            try {
                added = this.collection.add(t);
            }
            catch (Throwable e) {
                this.failAndCancel(e);
                return;
            }
            if (added) {
                this.downstream.onItem(t);
            } else {
                this.request(1L);
            }
        }

        @Override
        public void onFailure(Throwable t) {
            super.onFailure(t);
            this.collection.clear();
        }

        @Override
        public void onCompletion() {
            super.onCompletion();
            this.collection.clear();
        }

        @Override
        public void cancel() {
            super.cancel();
            this.collection.clear();
        }
    }
}

