/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public class UniCreateFromCompletionStage<T>
extends AbstractUni<T> {
    private final Supplier<? extends CompletionStage<? extends T>> supplier;

    public UniCreateFromCompletionStage(Supplier<? extends CompletionStage<? extends T>> supplier) {
        this.supplier = supplier;
    }

    static <O> void forwardFromCompletionStage(CompletionStage<? extends O> stage, UniSubscriber<? super O> subscriber) {
        subscriber.onSubscribe(() -> stage.toCompletableFuture().cancel(false));
        stage.whenComplete((res, fail) -> {
            if (fail != null) {
                if (fail instanceof CompletionException) {
                    subscriber.onFailure(fail.getCause());
                } else {
                    subscriber.onFailure((Throwable)fail);
                }
            } else {
                subscriber.onItem(res);
            }
        });
    }

    @Override
    protected void subscribing(UniSubscriber<? super T> subscriber) {
        CompletionStage<? extends T> stage;
        try {
            stage = this.supplier.get();
        }
        catch (Throwable e) {
            EmptyUniSubscription.propagateFailureEvent(subscriber, e);
            return;
        }
        if (stage == null) {
            EmptyUniSubscription.propagateFailureEvent(subscriber, new NullPointerException("The produced CompletionStage is `null`"));
            return;
        }
        UniCreateFromCompletionStage.forwardFromCompletionStage(stage, subscriber);
    }
}

