/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.exceptionmappers;

import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.RestResponse;
import org.jboss.resteasy.reactive.server.spi.AsyncExceptionMapperContext;

public final class AsyncExceptionMappingUtil {
    private static final Logger log = Logger.getLogger(AsyncExceptionMappingUtil.class);
    private static final Response DEFAULT_RESPONSE = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Internal Server Error").build();
    public static final Response DEFAULT_UNAUTHORIZED_RESPONSE = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Not Authenticated").build();

    private AsyncExceptionMappingUtil() {
    }

    public static void handleUniResponse(Uni<Response> asyncResponse, final AsyncExceptionMapperContext context) {
        context.suspend();
        asyncResponse.subscribe().with((Consumer)new Consumer<Response>(){

            @Override
            public void accept(Response response) {
                if (response == null) {
                    log.debug((Object)"Response was null, returning default error response");
                    context.setResponse(DEFAULT_RESPONSE);
                } else {
                    context.setResponse(response);
                }
                context.resume();
            }
        }, (Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable throwable) {
                log.error((Object)"Unable to convert exception to Response", throwable);
                context.setResponse(DEFAULT_RESPONSE);
                context.resume();
            }
        });
    }

    public static void handleUniRestResponse(Uni<? extends RestResponse<?>> asyncResponse, AsyncExceptionMapperContext context) {
        AsyncExceptionMappingUtil.handleUniResponse((Uni<Response>)asyncResponse.map(new Function<RestResponse<?>, Response>(){

            @Override
            public Response apply(RestResponse<?> t) {
                return t != null ? t.toResponse() : null;
            }
        }), context);
    }
}

