/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime.security;

import io.quarkus.arc.Arc;
import io.quarkus.resteasy.reactive.server.runtime.security.ResourceMethodDescription;
import io.quarkus.vertx.http.runtime.security.EagerSecurityInterceptorStorage;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class EagerSecurityInterceptorHandler
implements ServerRestHandler {
    private final Consumer<RoutingContext> interceptor;

    private EagerSecurityInterceptorHandler(Consumer<RoutingContext> interceptor) {
        this.interceptor = interceptor;
    }

    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        this.interceptor.accept((RoutingContext)requestContext.unwrap(RoutingContext.class));
    }

    public static class Customizer
    implements HandlerChainCustomizer {
        public static HandlerChainCustomizer newInstance() {
            return new Customizer();
        }

        public List<ServerRestHandler> handlers(HandlerChainCustomizer.Phase phase, ResourceClass resourceClass, ServerResourceMethod serverResourceMethod) {
            if (phase == HandlerChainCustomizer.Phase.AFTER_MATCH) {
                ResourceMethodDescription desc = ResourceMethodDescription.of(serverResourceMethod);
                EagerSecurityInterceptorStorage interceptorStorage = (EagerSecurityInterceptorStorage)Arc.container().instance(EagerSecurityInterceptorStorage.class, new Annotation[0]).get();
                Consumer interceptor = interceptorStorage.getInterceptor(desc.invokedMethodDesc());
                if (interceptor == null && desc.fallbackMethodDesc() != null) {
                    interceptor = interceptorStorage.getInterceptor(desc.fallbackMethodDesc());
                }
                if (interceptor == null) {
                    throw new IllegalStateException("Security annotation placed on resource method '%s#%s' wasn't detected by Quarkus during the build time.\nPlease consult https://quarkus.io/guides/cdi-reference#bean_discovery on how to make the module containing the code discoverable by Quarkus.\n".formatted(desc.invokedMethodDesc().getClassName(), desc.invokedMethodDesc().getMethodName()));
                }
                return Collections.singletonList(new EagerSecurityInterceptorHandler(interceptor));
            }
            return Collections.emptyList();
        }
    }
}

