/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.registry.ValueRegistry;
import io.quarkus.test.junit.QuarkusTestExtensionState;
import java.lang.reflect.Field;

public class ValueRegistryInjector {
    public static void inject(Object testInstance, QuarkusTestExtensionState extensionContext) {
        ValueRegistry valueRegistry = extensionContext.getValueRegistry();
        for (Class<?> c = testInstance.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                if (f.getType().equals(ValueRegistry.class)) {
                    try {
                        f.setAccessible(true);
                        f.set(testInstance, valueRegistry);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to set field '" + f.getName() + "'", e);
                    }
                }
                ValueRegistry.RuntimeKey key = ValueRegistry.RuntimeKey.key(f.getType());
                if (!valueRegistry.containsKey(key)) continue;
                try {
                    f.setAccessible(true);
                    f.set(testInstance, valueRegistry.get(key));
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to set field '" + f.getName() + "'", e);
                }
            }
        }
    }
}

