/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev;

import io.quarkus.deployment.devmode.HotReplacementContext;
import io.quarkus.deployment.devmode.HotReplacementSetup;
import io.quarkus.dev.ClassLoaderCompiler;
import io.quarkus.dev.DevModeContext;
import io.quarkus.dev.DevModeMain;
import io.quarkus.runtime.Timing;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class RuntimeUpdatesProcessor
implements HotReplacementContext {
    private static final String CLASS_EXTENSION = ".class";
    private final DevModeContext context;
    private final ClassLoaderCompiler compiler;
    private volatile long lastChange = System.currentTimeMillis();
    private volatile Map<String, Boolean> watchedFilePaths = Collections.emptyMap();
    private final Map<Path, Long> watchedFileTimestamps = new ConcurrentHashMap<Path, Long>();
    private final Map<Path, Path> classFilePathToSourceFilePath = new ConcurrentHashMap<Path, Path>();
    private static final Logger log = Logger.getLogger((String)RuntimeUpdatesProcessor.class.getPackage().getName());
    private final List<Runnable> preScanSteps = new CopyOnWriteArrayList<Runnable>();
    private final List<Consumer<Set<String>>> noRestartChangesConsumers = new CopyOnWriteArrayList<Consumer<Set<String>>>();
    private final List<HotReplacementSetup> hotReplacementSetup = new ArrayList<HotReplacementSetup>();
    private final DevModeMain devModeMain;

    public RuntimeUpdatesProcessor(DevModeContext context, ClassLoaderCompiler compiler, DevModeMain devModeMain) {
        this.context = context;
        this.compiler = compiler;
        this.devModeMain = devModeMain;
    }

    public Path getClassesDir() {
        Iterator<DevModeContext.ModuleInfo> iterator = this.context.getModules().iterator();
        if (iterator.hasNext()) {
            DevModeContext.ModuleInfo i = iterator.next();
            return Paths.get(i.getResourcePath(), new String[0]);
        }
        return null;
    }

    public List<Path> getSourcesDir() {
        return this.context.getModules().stream().flatMap(m -> m.getSourcePaths().stream()).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
    }

    public List<Path> getResourcesDir() {
        ArrayList<Path> ret = new ArrayList<Path>();
        for (DevModeContext.ModuleInfo i : this.context.getModules()) {
            if (i.getResourcePath() == null) continue;
            ret.add(Paths.get(i.getResourcePath(), new String[0]));
        }
        Collections.reverse(ret);
        return ret;
    }

    public Throwable getDeploymentProblem() {
        return DevModeMain.compileProblem != null ? DevModeMain.compileProblem : DevModeMain.deploymentProblem;
    }

    public boolean isTest() {
        return this.context.isTest();
    }

    public boolean doScan(boolean userInitiated) throws IOException {
        boolean restartNeeded;
        long startNanoseconds = System.nanoTime();
        for (Runnable step : this.preScanSteps) {
            try {
                step.run();
            }
            catch (Throwable t) {
                log.error((Object)"Pre Scan step failed", t);
            }
        }
        boolean classChanged = this.checkForChangedClasses();
        Set<String> filesChanged = this.checkForFileChange();
        boolean bl = restartNeeded = classChanged || DevModeMain.deploymentProblem != null && userInitiated;
        if (!restartNeeded && !filesChanged.isEmpty()) {
            restartNeeded = filesChanged.stream().map(this.watchedFilePaths::get).anyMatch(Boolean.TRUE::equals);
        }
        if (restartNeeded) {
            this.devModeMain.restartApp(filesChanged);
            log.infof("Hot replace total time: %ss ", (Object)Timing.convertToBigDecimalSeconds((long)(System.nanoTime() - startNanoseconds)));
            return true;
        }
        if (!filesChanged.isEmpty()) {
            for (Consumer<Set<String>> consumer : this.noRestartChangesConsumers) {
                try {
                    consumer.accept(filesChanged);
                }
                catch (Throwable t) {
                    log.error((Object)"Changed files consumer failed", t);
                }
            }
            log.infof("Files changed but restart not needed - notified extensions in: %ss ", (Object)Timing.convertToBigDecimalSeconds((long)(System.nanoTime() - startNanoseconds)));
        }
        return false;
    }

    public void addPreScanStep(Runnable runnable) {
        this.preScanSteps.add(runnable);
    }

    public void consumeNoRestartChanges(Consumer<Set<String>> consumer) {
        this.noRestartChangesConsumers.add(consumer);
    }

    boolean checkForChangedClasses() throws IOException {
        boolean hasChanges = false;
        for (DevModeContext.ModuleInfo module : this.context.getModules()) {
            ArrayList<Path> moduleChangedSourceFilePaths = new ArrayList<Path>();
            for (String sourcePath : module.getSourcePaths()) {
                Set changedSourceFiles;
                try (Stream<Path> sourcesStream = Files.walk(Paths.get(sourcePath, new String[0]), new FileVisitOption[0]);){
                    changedSourceFiles = ((Stream)sourcesStream.parallel()).filter(p -> this.matchingHandledExtension((Path)p).isPresent() && this.wasRecentlyModified((Path)p)).map(Path::toFile).collect(Collectors.toCollection(ConcurrentSkipListSet::new));
                }
                if (changedSourceFiles.isEmpty()) continue;
                log.info((Object)("Changed source files detected, recompiling " + changedSourceFiles));
                try {
                    Set changedPaths = changedSourceFiles.stream().map(File::toPath).collect(Collectors.toSet());
                    moduleChangedSourceFilePaths.addAll(changedPaths);
                    this.compiler.compile(sourcePath, changedSourceFiles.stream().collect(Collectors.groupingBy(this::getFileExtension, Collectors.toSet())));
                    DevModeMain.compileProblem = null;
                }
                catch (Exception e) {
                    DevModeMain.compileProblem = e;
                    return false;
                }
            }
            if (!this.checkForClassFilesChangesInModule(module, moduleChangedSourceFilePaths)) continue;
            hasChanges = true;
        }
        if (hasChanges) {
            this.lastChange = System.currentTimeMillis();
        }
        return hasChanges;
    }

    private boolean checkForClassFilesChangesInModule(DevModeContext.ModuleInfo module, List<Path> moduleChangedSourceFiles) {
        boolean hasChanges;
        boolean bl = hasChanges = !moduleChangedSourceFiles.isEmpty();
        if (module.getClassesPath() == null) {
            return hasChanges;
        }
        try {
            for (String folder : module.getClassesPath().split(File.pathSeparator)) {
                Path moduleClassesPath = Paths.get(folder, new String[0]);
                try (Stream<Path> classesStream = Files.walk(moduleClassesPath, new FileVisitOption[0]);){
                    Set classFilePaths = ((Stream)classesStream.parallel()).filter(path -> path.toString().endsWith(CLASS_EXTENSION)).collect(Collectors.toSet());
                    for (Path classFilePath : classFilePaths) {
                        Path sourceFilePath = this.retrieveSourceFilePathForClassFile(classFilePath, moduleChangedSourceFiles, module);
                        long classFileModificationTime = Files.getLastModifiedTime(classFilePath, new LinkOption[0]).toMillis();
                        if (sourceFilePath != null) {
                            if (!sourceFilePath.toFile().exists()) {
                                Files.deleteIfExists(classFilePath);
                                this.classFilePathToSourceFilePath.remove(classFilePath);
                                hasChanges = true;
                                continue;
                            }
                            this.classFilePathToSourceFilePath.put(classFilePath, sourceFilePath);
                            if (classFileModificationTime > this.lastChange) {
                                hasChanges = true;
                                continue;
                            }
                            if (!moduleChangedSourceFiles.contains(sourceFilePath)) continue;
                            Files.deleteIfExists(classFilePath);
                            this.classFilePathToSourceFilePath.remove(classFilePath);
                            hasChanges = true;
                            continue;
                        }
                        if (classFileModificationTime <= this.lastChange) continue;
                        hasChanges = true;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return hasChanges;
    }

    private Path retrieveSourceFilePathForClassFile(Path classFilePath, List<Path> moduleChangedSourceFiles, DevModeContext.ModuleInfo module) {
        Path sourceFilePath = this.classFilePathToSourceFilePath.get(classFilePath);
        if (sourceFilePath == null || moduleChangedSourceFiles.contains(sourceFilePath)) {
            sourceFilePath = this.compiler.findSourcePath(classFilePath, module.getSourcePaths(), module.getClassesPath());
        }
        return sourceFilePath;
    }

    private Optional<String> matchingHandledExtension(Path p) {
        return this.compiler.allHandledExtensions().stream().filter(e -> p.toString().endsWith((String)e)).findFirst();
    }

    private String getFileExtension(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(46);
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf);
    }

    private Set<String> checkForFileChange() {
        HashSet<String> ret = new HashSet<String>();
        for (DevModeContext.ModuleInfo module : this.context.getModules()) {
            boolean doCopy = true;
            String rootPath = module.getResourcePath();
            if (rootPath == null) {
                rootPath = module.getClassesPath();
                doCopy = false;
            }
            if (rootPath == null) continue;
            Path root = Paths.get(rootPath, new String[0]);
            Path classesDir = Paths.get(module.getClassesPath(), new String[0]);
            for (String path : this.watchedFilePaths.keySet()) {
                Path file = root.resolve(path);
                if (file.toFile().exists()) {
                    try {
                        Long existing;
                        long value = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
                        if (value <= (existing = this.watchedFileTimestamps.get(file))) continue;
                        ret.add(path);
                        log.infof("File change detected: %s", (Object)file);
                        if (doCopy) {
                            Path target = classesDir.resolve(path);
                            byte[] data = Files.readAllBytes(file);
                            try (FileOutputStream out = new FileOutputStream(target.toFile());){
                                out.write(data);
                            }
                        }
                        this.watchedFileTimestamps.put(file, value);
                        continue;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.watchedFileTimestamps.put(file, 0L);
                Path target = classesDir.resolve(path);
                try {
                    Files.deleteIfExists(target);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return ret;
    }

    private boolean wasRecentlyModified(Path p) {
        try {
            long sourceMod = Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
            return sourceMod > this.lastChange;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RuntimeUpdatesProcessor setWatchedFilePaths(Map<String, Boolean> watchedFilePaths) {
        this.watchedFilePaths = watchedFilePaths;
        this.watchedFileTimestamps.clear();
        for (DevModeContext.ModuleInfo module : this.context.getModules()) {
            String rootPath = module.getResourcePath();
            if (rootPath == null) {
                rootPath = module.getClassesPath();
            }
            if (rootPath == null) continue;
            Path root = Paths.get(rootPath, new String[0]);
            for (String path : watchedFilePaths.keySet()) {
                Path config = root.resolve(path);
                if (config.toFile().exists()) {
                    try {
                        this.watchedFileTimestamps.put(config, Files.getLastModifiedTime(config, new LinkOption[0]).toMillis());
                        continue;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.watchedFileTimestamps.put(config, 0L);
            }
        }
        return this;
    }

    public void addHotReplacementSetup(HotReplacementSetup service) {
        this.hotReplacementSetup.add(service);
    }

    public void startupFailed() {
        for (HotReplacementSetup i : this.hotReplacementSetup) {
            i.handleFailedInitialStart();
        }
    }
}

