/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodDescriptor;
import java.util.HashMap;
import java.util.Map;

public final class AccessorFinder {
    private static final String JLO = "java/lang/Object";
    private final Map<FieldDescriptor, MethodDescriptor> setters = new HashMap<FieldDescriptor, MethodDescriptor>();
    private final Map<FieldDescriptor, MethodDescriptor> getters = new HashMap<FieldDescriptor, MethodDescriptor>();
    private final Map<MethodDescriptor, MethodDescriptor> ctors = new HashMap<MethodDescriptor, MethodDescriptor>();

    public synchronized MethodDescriptor getSetterFor(FieldDescriptor fieldDescriptor) {
        MethodDescriptor methodDescriptor = this.setters.get(fieldDescriptor);
        if (methodDescriptor != null) {
            return methodDescriptor;
        }
        String declaringClass = fieldDescriptor.getDeclaringClass();
        String accessorName = declaringClass + "$$accessor";
        String rawFieldType = fieldDescriptor.getType();
        boolean primitive = DescriptorUtils.isPrimitive((String)rawFieldType);
        String fieldType = primitive ? rawFieldType : DescriptorUtils.getTypeStringFromDescriptorFormat((String)rawFieldType);
        String publicType = primitive ? fieldType : JLO;
        methodDescriptor = MethodDescriptor.ofMethod((Object)accessorName, (String)("set_" + fieldDescriptor.getName()), Void.TYPE, (Object[])new Object[]{JLO, publicType});
        this.setters.put(fieldDescriptor, methodDescriptor);
        return methodDescriptor;
    }

    public synchronized MethodDescriptor getGetterFor(FieldDescriptor fieldDescriptor) {
        MethodDescriptor methodDescriptor = this.getters.get(fieldDescriptor);
        if (methodDescriptor != null) {
            return methodDescriptor;
        }
        String declaringClass = fieldDescriptor.getDeclaringClass();
        String accessorName = declaringClass + "$$accessor";
        String rawFieldType = fieldDescriptor.getType();
        boolean primitive = DescriptorUtils.isPrimitive((String)rawFieldType);
        String fieldType = primitive ? rawFieldType : DescriptorUtils.getTypeStringFromDescriptorFormat((String)rawFieldType);
        String publicType = primitive ? fieldType : JLO;
        methodDescriptor = MethodDescriptor.ofMethod((String)accessorName, (String)("get_" + fieldDescriptor.getName()), (String)publicType, (String[])new String[]{JLO});
        this.getters.put(fieldDescriptor, methodDescriptor);
        return methodDescriptor;
    }

    public synchronized MethodDescriptor getConstructorFor(MethodDescriptor ctor) {
        MethodDescriptor methodDescriptor = this.ctors.get(ctor);
        if (methodDescriptor != null) {
            return methodDescriptor;
        }
        if (!ctor.getName().equals("<init>")) {
            throw new IllegalArgumentException("Parameter 'ctor' must be a valid constructor descriptor");
        }
        String declaringClass = ctor.getDeclaringClass();
        String accessorName = declaringClass + "$$accessor";
        String[] parameterTypes = ctor.getParameterTypes();
        String[] publicParameterTypes = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            publicParameterTypes[i] = DescriptorUtils.isPrimitive((String)parameterTypes[i]) ? parameterTypes[i] : JLO;
        }
        StringBuilder b = new StringBuilder();
        for (String parameterType : parameterTypes) {
            b.append('_').append(parameterType.replace('.', '_'));
        }
        String codedName = b.toString();
        methodDescriptor = MethodDescriptor.ofMethod((String)accessorName, (String)("construct" + codedName), (String)JLO, (String[])publicParameterTypes);
        this.ctors.put(ctor, methodDescriptor);
        return methodDescriptor;
    }
}

