/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime.caffeine;

import io.quarkus.cache.Cache;
import io.quarkus.cache.CacheManager;
import io.quarkus.cache.runtime.CacheManagerImpl;
import io.quarkus.cache.runtime.caffeine.CaffeineCacheImpl;
import io.quarkus.cache.runtime.caffeine.CaffeineCacheInfo;
import io.quarkus.cache.runtime.caffeine.metrics.MetricsInitializer;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class CaffeineCacheBuildRecorder {
    private static final Logger LOGGER = Logger.getLogger(CaffeineCacheBuildRecorder.class);

    public Supplier<CacheManager> getCacheManagerSupplier(final Set<CaffeineCacheInfo> cacheInfos, final MetricsInitializer metricsInitializer) {
        Objects.requireNonNull(cacheInfos);
        return new Supplier<CacheManager>(){

            @Override
            public CacheManager get() {
                if (cacheInfos.isEmpty()) {
                    return new CacheManagerImpl(Collections.emptyMap());
                }
                HashMap<String, Cache> caches = new HashMap<String, Cache>(cacheInfos.size() + 1, 1.0f);
                for (CaffeineCacheInfo cacheInfo : cacheInfos) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debugf("Building Caffeine cache [%s] with [initialCapacity=%s], [maximumSize=%s], [expireAfterWrite=%s], [expireAfterAccess=%s] and [metricsEnabled=%s]", new Object[]{cacheInfo.name, cacheInfo.initialCapacity, cacheInfo.maximumSize, cacheInfo.expireAfterWrite, cacheInfo.expireAfterAccess, cacheInfo.metricsEnabled});
                    }
                    boolean recordMetrics = metricsInitializer.metricsEnabled() && cacheInfo.metricsEnabled;
                    CaffeineCacheImpl cache = new CaffeineCacheImpl(cacheInfo, recordMetrics);
                    if (recordMetrics) {
                        metricsInitializer.recordMetrics(cache.cache, cacheInfo.name);
                    } else if (cacheInfo.metricsEnabled) {
                        LOGGER.warnf("Metrics won't be recorded for cache '%s' because the application does not depend on a Micrometer extension. This warning can be fixed by disabling the cache metrics in the configuration or by adding a Micrometer extension to the pom.xml file.", (Object)cacheInfo.name);
                    }
                    caches.put(cacheInfo.name, cache);
                }
                return new CacheManagerImpl(caches);
            }
        };
    }
}

