/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.lazy;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.org.jspecify.annotations.Nullable;
import org.gradle.internal.lazy.Lazy;

class AtomicLazy<T>
implements Lazy<T> {
    private static final Object UNINITIALIZED = new Object();
    private final AtomicReference<@Nullable Object> value = new AtomicReference<Object>(UNINITIALIZED);
    private volatile @Nullable Supplier<T> supplier;

    public AtomicLazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public T get() {
        Supplier<T> s = this.supplier;
        if (s != null) {
            T t = s.get();
            if (this.value.compareAndSet(UNINITIALIZED, t)) {
                this.supplier = null;
                return t;
            }
            this.supplier = null;
        }
        Object result = Cast.uncheckedNonnullCast(this.value.get());
        return result;
    }
}

