/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.creator.ops;

import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ops.ObjectOps;
import io.quarkus.gizmo2.desc.Descs;
import io.quarkus.gizmo2.desc.MethodDesc;
import java.util.Collection;

public class CollectionOps
extends ObjectOps {
    public CollectionOps(BlockCreator bc, Expr obj) {
        super(Collection.class, bc, obj);
    }

    protected CollectionOps(Class<?> receiverType, BlockCreator bc, Expr obj) {
        super(receiverType.asSubclass(Collection.class), bc, obj);
    }

    public Expr size() {
        return this.bc.invokeInterface(Descs.MD_Collection.size, this.obj);
    }

    public Expr isEmpty() {
        return this.bc.invokeInterface(Descs.MD_Collection.isEmpty, this.obj);
    }

    public Expr add(Expr item) {
        return this.bc.invokeInterface((MethodDesc)Descs.MD_Collection.add, this.obj, item);
    }

    public Expr addAll(Expr other) {
        return this.bc.invokeInterface((MethodDesc)Descs.MD_Collection.addAll, this.obj, other);
    }

    public void clear() {
        this.bc.invokeInterface(Descs.MD_Collection.clear, this.obj);
    }

    public Expr contains(Expr item) {
        return this.bc.invokeInterface((MethodDesc)Descs.MD_Collection.contains, this.obj, item);
    }

    public Expr containsAll(Expr other) {
        return this.bc.invokeInterface((MethodDesc)Descs.MD_Collection.containsAll, this.obj, other);
    }

    public Expr iterator() {
        return this.bc.invokeInterface(Descs.MD_Iterable.iterator, this.obj);
    }

    public Expr remove(Expr item) {
        return this.bc.invokeInterface((MethodDesc)Descs.MD_Collection.remove, this.obj, item);
    }

    public Expr removeAll(Expr other) {
        return this.bc.invokeInterface((MethodDesc)Descs.MD_Collection.removeAll, this.obj, other);
    }
}

