/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ContextCreator;
import io.quarkus.arc.CurrentContextFactory;
import io.quarkus.arc.InjectableContext;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import jakarta.enterprise.context.NormalScope;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ContextConfigurator {
    private final AtomicBoolean consumed = new AtomicBoolean(false);
    private final Consumer<ContextConfigurator> configuratorConsumer;
    Class<? extends Annotation> scopeAnnotation;
    boolean isNormal;
    Function<CreateGeneration, Expr> creator;
    final Map<String, Object> params;

    ContextConfigurator(Class<? extends Annotation> scopeAnnotation, Consumer<ContextConfigurator> configuratorConsumer) {
        this.scopeAnnotation = Objects.requireNonNull(scopeAnnotation);
        this.params = new HashMap<String, Object>();
        this.configuratorConsumer = configuratorConsumer;
        this.isNormal = scopeAnnotation.isAnnotationPresent(NormalScope.class);
    }

    public ContextConfigurator param(String name, Class<?> value) {
        this.params.put(name, value);
        return this;
    }

    public ContextConfigurator param(String name, int value) {
        this.params.put(name, value);
        return this;
    }

    public ContextConfigurator param(String name, long value) {
        this.params.put(name, value);
        return this;
    }

    public ContextConfigurator param(String name, double value) {
        this.params.put(name, value);
        return this;
    }

    public ContextConfigurator param(String name, String value) {
        this.params.put(name, value);
        return this;
    }

    public ContextConfigurator param(String name, boolean value) {
        this.params.put(name, value);
        return this;
    }

    public ContextConfigurator normal() {
        return this.normal(true);
    }

    public ContextConfigurator normal(boolean value) {
        this.isNormal = value;
        return this;
    }

    public ContextConfigurator contextClass(Class<? extends InjectableContext> contextClazz) {
        if (!Modifier.isPublic(contextClazz.getModifiers()) || Modifier.isAbstract(contextClazz.getModifiers()) || contextClazz.isAnonymousClass() || contextClazz.isLocalClass() || contextClazz.getEnclosingClass() != null && !Modifier.isStatic(contextClazz.getModifiers())) {
            throw new IllegalArgumentException("A context class must be a public non-abstract top-level or static nested class");
        }
        Constructor<?> constructor = this.getConstructor(contextClazz);
        if (constructor == null) {
            throw new IllegalArgumentException("A context class must either declare a no-args constructor or a constructor that accepts a single parameter of type io.quarkus.arc.CurrentContextFactory");
        }
        return this.creator((CreateGeneration cg) -> {
            BlockCreator bc = cg.method();
            List args = constructor.getParameterCount() == 0 ? List.of() : List.of(cg.currentContextFactory());
            return bc.new_(ConstructorDesc.of((Constructor)constructor), args);
        });
    }

    private Constructor<?> getConstructor(Class<? extends InjectableContext> contextClazz) {
        Constructor<? extends InjectableContext> constructor = null;
        try {
            constructor = contextClazz.getDeclaredConstructor(CurrentContextFactory.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (constructor == null) {
            try {
                constructor = contextClazz.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return constructor;
    }

    public ContextConfigurator creator(Class<? extends ContextCreator> creatorClazz) {
        return this.creator((CreateGeneration cg) -> {
            BlockCreator bc = cg.method();
            LocalVar params = bc.localVar("params", bc.new_(HashMap.class));
            bc.withMap((Expr)params).put((Expr)Const.of((String)"io.quarkus.arc.currentContextFactory"), (Expr)cg.currentContextFactory());
            for (Map.Entry<String, Object> entry : this.params.entrySet()) {
                Const value;
                Object patt0$temp = entry.getValue();
                if (patt0$temp instanceof String) {
                    String s = (String)patt0$temp;
                    value = Const.of((String)s);
                } else {
                    Object patt1$temp = entry.getValue();
                    if (patt1$temp instanceof Integer) {
                        Integer i = (Integer)patt1$temp;
                        value = Const.of((Integer)i);
                    } else {
                        Object patt2$temp = entry.getValue();
                        if (patt2$temp instanceof Long) {
                            Long l = (Long)patt2$temp;
                            value = Const.of((Long)l);
                        } else {
                            Object patt3$temp = entry.getValue();
                            if (patt3$temp instanceof Double) {
                                Double d = (Double)patt3$temp;
                                value = Const.of((Double)d);
                            } else {
                                Object patt4$temp = entry.getValue();
                                if (patt4$temp instanceof Class) {
                                    Class c = (Class)patt4$temp;
                                    value = Const.of((Class)c);
                                } else {
                                    Object patt5$temp = entry.getValue();
                                    if (patt5$temp instanceof Boolean) {
                                        Boolean b = (Boolean)patt5$temp;
                                        value = Const.of((Boolean)b);
                                    } else {
                                        throw new IllegalArgumentException("Unknown parameter " + entry.getKey() + ": " + String.valueOf(entry.getValue()));
                                    }
                                }
                            }
                        }
                    }
                }
                bc.withMap((Expr)params).put((Expr)Const.of((String)entry.getKey()), (Expr)value);
            }
            Expr creator = bc.new_(creatorClazz);
            return bc.invokeInterface(MethodDesc.of(ContextCreator.class, (String)"create", InjectableContext.class, (Class[])new Class[]{Map.class}), creator, (Expr)params);
        });
    }

    public ContextConfigurator creator(Function<CreateGeneration, Expr> creator) {
        this.creator = creator;
        return this;
    }

    public void done() {
        if (this.consumed.compareAndSet(false, true)) {
            Objects.requireNonNull(this.creator);
            Objects.requireNonNull(this.configuratorConsumer).accept(this);
        }
    }

    public static interface CreateGeneration {
        public BlockCreator method();

        public Var currentContextFactory();
    }
}

