/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DecoratorInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.ObserverInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class Reproducibility {
    static final Comparator<BeanInfo> BEAN_COMPARATOR = Comparator.comparing(BeanInfo::getIdentifier);
    static final Comparator<ObserverInfo> OBSERVER_COMPARATOR = Comparator.comparing(ObserverInfo::getIdentifier);

    static List<BeanInfo> orderedBeans(Collection<BeanInfo> beans) {
        ArrayList<BeanInfo> list = new ArrayList<BeanInfo>(beans);
        list.sort(BEAN_COMPARATOR);
        return list;
    }

    static List<InterceptorInfo> orderedInterceptors(Collection<InterceptorInfo> interceptors) {
        ArrayList<InterceptorInfo> list = new ArrayList<InterceptorInfo>(interceptors);
        list.sort(BEAN_COMPARATOR);
        return list;
    }

    static List<DecoratorInfo> orderedDecorators(Collection<DecoratorInfo> decorators) {
        ArrayList<DecoratorInfo> list = new ArrayList<DecoratorInfo>(decorators);
        list.sort(BEAN_COMPARATOR);
        return list;
    }

    static List<ObserverInfo> orderedObservers(Collection<ObserverInfo> observers) {
        ArrayList<ObserverInfo> list = new ArrayList<ObserverInfo>(observers);
        list.sort(OBSERVER_COMPARATOR);
        return list;
    }
}

