/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.marshal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler2;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class StatelessMarshalerUtil {
    private static final MarshalerContext.Key GROUPER_KEY = MarshalerContext.key();
    private static final MarshalerContext.Key ATTRIBUTES_SIZE_CALCULATOR_KEY = MarshalerContext.key();

    public static <T> Map<Resource, Map<InstrumentationScopeInfo, List<T>>> groupByResourceAndScope(Collection<T> dataList, Function<T, Resource> getResource, Function<T, InstrumentationScopeInfo> getInstrumentationScope, MarshalerContext context) {
        Map result = context.getIdentityMap();
        Grouper grouper = context.getInstance(GROUPER_KEY, () -> new Grouper());
        grouper.initialize(result, getResource, getInstrumentationScope, context);
        dataList.forEach(grouper);
        return result;
    }

    public static int sizeStringWithContext(ProtoFieldInfo field, @Nullable String value, MarshalerContext context) {
        if (value == null || value.isEmpty()) {
            return StatelessMarshalerUtil.sizeBytes(field, 0);
        }
        if (context.marshalStringNoAllocation()) {
            int utf8Size = context.getStringEncoder().getUtf8Size(value);
            context.addSize(utf8Size);
            return StatelessMarshalerUtil.sizeBytes(field, utf8Size);
        }
        byte[] valueUtf8 = MarshalerUtil.toBytes(value);
        context.addData(valueUtf8);
        return StatelessMarshalerUtil.sizeBytes(field, valueUtf8.length);
    }

    private static int sizeBytes(ProtoFieldInfo field, int length) {
        if (length == 0) {
            return 0;
        }
        return field.getTagSize() + CodedOutputStream.computeLengthDelimitedFieldSize(length);
    }

    public static <T> int sizeRepeatedMessageWithContext(ProtoFieldInfo field, List<? extends T> messages, StatelessMarshaler<T> marshaler, MarshalerContext context) {
        if (messages.isEmpty()) {
            return 0;
        }
        int size = 0;
        int fieldTagSize = field.getTagSize();
        for (int i = 0; i < messages.size(); ++i) {
            T message = messages.get(i);
            int sizeIndex = context.addSize();
            int fieldSize = marshaler.getBinarySerializedSize(message, context);
            context.setSize(sizeIndex, fieldSize);
            size += fieldTagSize + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
        }
        return size;
    }

    public static <T> int sizeRepeatedMessageWithContext(ProtoFieldInfo field, Collection<? extends T> messages, StatelessMarshaler<T> marshaler, MarshalerContext context, MarshalerContext.Key key) {
        if (messages instanceof List) {
            return StatelessMarshalerUtil.sizeRepeatedMessageWithContext(field, (List)messages, marshaler, context);
        }
        if (messages.isEmpty()) {
            return 0;
        }
        RepeatedElementSizeCalculator sizeCalculator = context.getInstance(key, () -> new RepeatedElementSizeCalculator());
        sizeCalculator.initialize(field, marshaler, context);
        messages.forEach(sizeCalculator);
        return sizeCalculator.size;
    }

    public static <K, V> int sizeRepeatedMessageWithContext(ProtoFieldInfo field, Map<K, V> messages, StatelessMarshaler2<K, V> marshaler, MarshalerContext context, MarshalerContext.Key key) {
        if (messages.isEmpty()) {
            return 0;
        }
        RepeatedElementPairSizeCalculator sizeCalculator = context.getInstance(key, () -> new RepeatedElementPairSizeCalculator());
        sizeCalculator.initialize(field, marshaler, context);
        messages.forEach(sizeCalculator);
        return sizeCalculator.size;
    }

    public static int sizeRepeatedMessageWithContext(ProtoFieldInfo field, Attributes attributes, StatelessMarshaler2<AttributeKey<?>, Object> marshaler, MarshalerContext context) {
        if (attributes.isEmpty()) {
            return 0;
        }
        RepeatedElementPairSizeCalculator sizeCalculator = context.getInstance(ATTRIBUTES_SIZE_CALCULATOR_KEY, () -> new RepeatedElementPairSizeCalculator());
        sizeCalculator.initialize(field, marshaler, context);
        attributes.forEach((BiConsumer)sizeCalculator);
        return sizeCalculator.size;
    }

    public static <T> int sizeMessageWithContext(ProtoFieldInfo field, T element, StatelessMarshaler<T> marshaler, MarshalerContext context) {
        int sizeIndex = context.addSize();
        int fieldSize = marshaler.getBinarySerializedSize(element, context);
        int size = field.getTagSize() + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
        context.setSize(sizeIndex, fieldSize);
        return size;
    }

    public static <K, V> int sizeMessageWithContext(ProtoFieldInfo field, K key, V value, StatelessMarshaler2<K, V> marshaler, MarshalerContext context) {
        int sizeIndex = context.addSize();
        int fieldSize = marshaler.getBinarySerializedSize(key, value, context);
        int size = field.getTagSize() + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
        context.setSize(sizeIndex, fieldSize);
        return size;
    }

    private StatelessMarshalerUtil() {
    }

    private static class Grouper<T>
    implements Consumer<T> {
        private Map<Resource, Map<InstrumentationScopeInfo, List<T>>> result;
        private Function<T, Resource> getResource;
        private Function<T, InstrumentationScopeInfo> getInstrumentationScope;
        private MarshalerContext context;

        private Grouper() {
        }

        void initialize(Map<Resource, Map<InstrumentationScopeInfo, List<T>>> result, Function<T, Resource> getResource, Function<T, InstrumentationScopeInfo> getInstrumentationScope, MarshalerContext context) {
            this.result = result;
            this.getResource = getResource;
            this.getInstrumentationScope = getInstrumentationScope;
            this.context = context;
        }

        @Override
        public void accept(T data) {
            InstrumentationScopeInfo instrumentationScopeInfo;
            List<Object> elementList;
            Resource resource = this.getResource.apply(data);
            Map<Object, List<Object>> scopeInfoListMap = this.result.get(resource);
            if (scopeInfoListMap == null) {
                scopeInfoListMap = this.context.getIdentityMap();
                this.result.put(resource, scopeInfoListMap);
            }
            if ((elementList = scopeInfoListMap.get(instrumentationScopeInfo = this.getInstrumentationScope.apply(data))) == null) {
                elementList = this.context.getList();
                scopeInfoListMap.put((InstrumentationScopeInfo)((Object)instrumentationScopeInfo), (List<T>)elementList);
            }
            elementList.add(data);
        }
    }

    private static class RepeatedElementSizeCalculator<T>
    implements Consumer<T> {
        private int size;
        private int fieldTagSize;
        private StatelessMarshaler<T> marshaler;
        private MarshalerContext context;

        private RepeatedElementSizeCalculator() {
        }

        void initialize(ProtoFieldInfo field, StatelessMarshaler<T> marshaler, MarshalerContext context) {
            this.size = 0;
            this.fieldTagSize = field.getTagSize();
            this.marshaler = marshaler;
            this.context = context;
        }

        @Override
        public void accept(T element) {
            int sizeIndex = this.context.addSize();
            int fieldSize = this.marshaler.getBinarySerializedSize(element, this.context);
            this.context.setSize(sizeIndex, fieldSize);
            this.size += this.fieldTagSize + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
        }
    }

    private static class RepeatedElementPairSizeCalculator<K, V>
    implements BiConsumer<K, V> {
        private int size;
        private int fieldTagSize;
        private StatelessMarshaler2<K, V> marshaler;
        private MarshalerContext context;

        private RepeatedElementPairSizeCalculator() {
        }

        void initialize(ProtoFieldInfo field, StatelessMarshaler2<K, V> marshaler, MarshalerContext context) {
            this.size = 0;
            this.fieldTagSize = field.getTagSize();
            this.marshaler = marshaler;
            this.context = context;
        }

        @Override
        public void accept(K key, V value) {
            int sizeIndex = this.context.addSize();
            int fieldSize = this.marshaler.getBinarySerializedSize(key, value, this.context);
            this.context.setSize(sizeIndex, fieldSize);
            this.size += this.fieldTagSize + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
        }
    }
}

