/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.invoke.TypeDescriptor;

public enum TypeKind {
    BOOLEAN(1, 4),
    BYTE(1, 8),
    CHAR(1, 5),
    SHORT(1, 9),
    INT(1, 10),
    LONG(2, 11),
    FLOAT(1, 6),
    DOUBLE(2, 7),
    REFERENCE(1, -1),
    VOID(0, -1);

    private ClassDesc upperBound;
    private final int slots;
    private final int newarrayCode;

    private TypeKind(int slots, int newarrayCode) {
        this.slots = slots;
        this.newarrayCode = newarrayCode;
    }

    public ClassDesc upperBound() {
        ClassDesc upper = this.upperBound;
        if (upper == null) {
            this.upperBound = this.fetchUpperBound();
            return this.upperBound;
        }
        return upper;
    }

    private ClassDesc fetchUpperBound() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> ConstantDescs.CD_boolean;
            case 1 -> ConstantDescs.CD_byte;
            case 2 -> ConstantDescs.CD_char;
            case 3 -> ConstantDescs.CD_short;
            case 4 -> ConstantDescs.CD_int;
            case 6 -> ConstantDescs.CD_float;
            case 5 -> ConstantDescs.CD_long;
            case 7 -> ConstantDescs.CD_double;
            case 8 -> ConstantDescs.CD_Object;
            case 9 -> ConstantDescs.CD_void;
        };
    }

    public int newarrayCode() {
        return this.newarrayCode;
    }

    public int slotSize() {
        return this.slots;
    }

    public TypeKind asLoadable() {
        return this.ordinal() < 4 ? INT : this;
    }

    public static TypeKind fromNewarrayCode(int newarrayCode) {
        return switch (newarrayCode) {
            case 4 -> BOOLEAN;
            case 5 -> CHAR;
            case 6 -> FLOAT;
            case 7 -> DOUBLE;
            case 8 -> BYTE;
            case 9 -> SHORT;
            case 10 -> INT;
            case 11 -> LONG;
            default -> throw new IllegalArgumentException("Bad newarray code: " + newarrayCode);
        };
    }

    public static TypeKind fromDescriptor(CharSequence s) {
        if (s.isEmpty()) {
            throw new IllegalArgumentException("Empty descriptor");
        }
        return switch (s.charAt(0)) {
            case 'L', '[' -> REFERENCE;
            case 'B' -> BYTE;
            case 'C' -> CHAR;
            case 'Z' -> BOOLEAN;
            case 'S' -> SHORT;
            case 'I' -> INT;
            case 'F' -> FLOAT;
            case 'J' -> LONG;
            case 'D' -> DOUBLE;
            case 'V' -> VOID;
            default -> throw new IllegalArgumentException("Bad type: " + String.valueOf(s));
        };
    }

    public static TypeKind from(TypeDescriptor.OfField<?> descriptor) {
        return descriptor.isPrimitive() ? TypeKind.fromDescriptor(descriptor.descriptorString()) : REFERENCE;
    }
}

