/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.dump;

import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.logging.LogUtils;
import fr.opensagres.xdocreport.core.registry.AbstractRegistry;
import fr.opensagres.xdocreport.document.discovery.IDumperDiscovery;
import fr.opensagres.xdocreport.document.dump.IDumper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumperRegistry
extends AbstractRegistry<IDumperDiscovery> {
    private static final DumperRegistry INSTANCE = new DumperRegistry();
    private static final Logger LOGGER = LogUtils.getLogger((String)DumperRegistry.class.getName());
    private Map<String, IDumper> dumpers = new HashMap<String, IDumper>();

    public DumperRegistry() {
        super(IDumperDiscovery.class);
    }

    public static DumperRegistry getRegistry() {
        return INSTANCE;
    }

    public IDumper findDumper(String kind) throws XDocReportException {
        IDumper dumper = this.getDumper(kind);
        if (dumper == null) {
            String msg = String.format("Cannot find dumper with kind=%s", dumper);
            LOGGER.severe(msg);
            throw new XDocReportException(msg);
        }
        return dumper;
    }

    public IDumper getDumper(String kind) {
        this.initializeIfNeeded();
        return this.dumpers.get(kind);
    }

    public Set<String> getKinds() {
        this.initializeIfNeeded();
        return this.dumpers.keySet();
    }

    protected void doDispose() {
        this.dumpers.clear();
    }

    protected boolean registerInstance(IDumperDiscovery discovery) {
        this.dumpers.put(discovery.getKind(), discovery.getDumper());
        return true;
    }
}

