/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.extension.command;

import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.command.JGitFlowCommand;
import com.atlassian.jgitflow.core.exception.JGitFlowExtensionException;
import com.atlassian.jgitflow.core.extension.ExtensionCommand;
import com.atlassian.jgitflow.core.extension.ExtensionFailStrategy;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.VersionType;
import com.atlassian.maven.plugins.jgitflow.helper.BranchHelper;
import com.atlassian.maven.plugins.jgitflow.helper.PomUpdater;
import com.atlassian.maven.plugins.jgitflow.helper.ProjectHelper;
import com.atlassian.maven.plugins.jgitflow.helper.SessionAndProjects;
import com.atlassian.maven.plugins.jgitflow.manager.tasks.CheckoutAndGetProjects;
import com.atlassian.maven.plugins.jgitflow.provider.BranchLabelProvider;
import com.atlassian.maven.plugins.jgitflow.provider.ContextProvider;
import com.atlassian.maven.plugins.jgitflow.provider.JGitFlowProvider;
import com.atlassian.maven.plugins.jgitflow.provider.ProjectCacheKey;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.jgit.api.Git;

@Component(role=UpdateDevelopWithNextDevVersionCommand.class)
public class UpdateDevelopWithNextDevVersionCommand
implements ExtensionCommand {
    @Requirement
    private BranchHelper branchHelper;
    @Requirement
    private ProjectHelper projectHelper;
    @Requirement
    private JGitFlowProvider jGitFlowProvider;
    @Requirement
    private CheckoutAndGetProjects checkoutAndGetProjects;
    @Requirement
    private BranchLabelProvider labelProvider;
    @Requirement
    private PomUpdater pomUpdater;
    @Requirement
    private ContextProvider contextProvider;

    public void execute(GitFlowConfiguration configuration, Git git, JGitFlowCommand gitFlowCommand, JGitFlowReporter reporter) throws JGitFlowExtensionException {
        try {
            JGitFlow flow = this.jGitFlowProvider.gitFlow();
            ReleaseContext ctx = this.contextProvider.getContext();
            String originalBranchName = this.branchHelper.getCurrentBranchName();
            SessionAndProjects sessionAndProjects = this.checkoutAndGetProjects.run(flow.getDevelopBranchName());
            List<MavenProject> developProjects = sessionAndProjects.getProjects();
            String developLabel = this.labelProvider.getNextVersionLabel(VersionType.DEVELOPMENT, ProjectCacheKey.DEVELOP_BRANCH, developProjects);
            this.pomUpdater.updatePomsWithNextDevelopmentVersion(ProjectCacheKey.DEVELOP_BRANCH, developProjects);
            this.projectHelper.commitAllPoms(flow.git(), developProjects, ctx.getScmCommentPrefix() + "updating poms for " + developLabel + " development" + ctx.getScmCommentSuffix());
            flow.git().checkout().setName(originalBranchName).call();
        }
        catch (Exception e) {
            throw new JGitFlowExtensionException("Error updating develop poms to next development version", (Throwable)e);
        }
    }

    public ExtensionFailStrategy failStrategy() {
        return ExtensionFailStrategy.ERROR;
    }
}

