/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.Capability;
import com.vaadin.pro.licensechecker.PreTrialValidator;
import java.util.EnumSet;
import java.util.Optional;

public class Capabilities {
    private final EnumSet<Capability> capabilities;

    public Capabilities() {
        this.capabilities = EnumSet.noneOf(Capability.class);
    }

    public Capabilities(Capability capability) {
        this.capabilities = EnumSet.of(capability);
    }

    public Capabilities(Capability ... capabilities) {
        this.capabilities = EnumSet.copyOf(EnumSet.of(capabilities[0], capabilities));
    }

    public boolean has(Capability capability) {
        return this.capabilities.contains((Object)capability);
    }

    public static Capabilities none() {
        return new Capabilities();
    }

    public static Capabilities of(Capability capability) {
        return new Capabilities(capability);
    }

    public static Capabilities of(Capability ... capabilities) {
        return new Capabilities(capabilities);
    }

    Optional<PreTrialValidator> getPreTrialValidator() {
        return Optional.ofNullable(this.has(Capability.PRE_TRIAL) ? new PreTrialValidator() : null);
    }
}

