/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jxc;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.tools.jxc.AptBasedTask;
import com.sun.tools.jxc.apt.SchemaGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Commandline;

public class SchemaGenTask
extends AptBasedTask {
    private final List schemas = new ArrayList();

    protected void setupCommandlineSwitches(Commandline cmd) {
        cmd.createArgument().setValue("-nocompile");
    }

    protected String getCompilationMessage() {
        return "Generating schema from ";
    }

    protected String getFailedMessage() {
        return "schema generation failed";
    }

    public Schema createSchema() {
        Schema s = new Schema();
        this.schemas.add(s);
        return s;
    }

    protected AnnotationProcessorFactory createFactory() {
        HashMap<String, File> m = new HashMap<String, File>();
        for (int i = 0; i < this.schemas.size(); ++i) {
            Schema schema = (Schema)this.schemas.get(i);
            if (m.containsKey(schema.namespace)) {
                throw new BuildException("the same namespace is specified twice");
            }
            m.put(schema.namespace, schema.file);
        }
        return new SchemaGenerator(m);
    }

    public class Schema {
        private String namespace;
        private File file;

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public void setFile(String fileName) {
            File dest = SchemaGenTask.this.getDestdir();
            if (dest == null) {
                dest = SchemaGenTask.this.getProject().getBaseDir();
            }
            this.file = new File(dest, fileName);
        }
    }
}

