/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.sql.PooledConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.AbstractTrueCacheConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIOtxen;
import oracle.jdbc.driver.T4CTTIOtxse;
import oracle.jdbc.driver.T4CTTIk2rpc;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy._Proxy_;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;
import oracle.jdbc.xa.client.OracleXADataSource;
import oracle.jdbc.xa.client.OracleXAResource;

class T4CXAResource
extends OracleXAResource {
    private static final String CLASS_NAME = T4CXAResource.class.getName();
    int[] applicationValueArr = new int[1];
    boolean isTransLoose = false;
    byte[] context;
    int errorNumber;
    private OpaqueString password = null;

    T4CXAResource(OracleConnection _physicalConn, OracleXAConnection xaconn, boolean _isTransLoose) throws XAException {
        super(_physicalConn, xaconn);
        this.isTransLoose = _isTransLoose;
    }

    @Override
    protected int doStart(Xid xid, int flag) throws XAException, SQLException {
        T4CConnection physicalConn = this.getT4CConnection();
        try (Monitor.CloseableLock lock = physicalConn.acquireCloseableLock();){
            int swtch;
            int returnVal = -1;
            if (this.isTransLoose) {
                flag |= 0x10000;
            }
            if ((swtch = flag & 0x8200000) == 0x8000000 && OracleXid.isLocalTransaction(xid)) {
                int n = 0;
                return n;
            }
            this.applicationValueArr[0] = 0;
            try {
                try {
                    T4CTTIOtxse otxse = physicalConn.otxse;
                    byte[] xidxid = null;
                    byte[] gtrid = xid.getGlobalTransactionId();
                    byte[] bqual = xid.getBranchQualifier();
                    int gtrid_l = 0;
                    int bqual_l = 0;
                    if (gtrid != null && bqual != null) {
                        gtrid_l = Math.min(gtrid.length, 64);
                        bqual_l = Math.min(bqual.length, 64);
                        xidxid = new byte[128];
                        System.arraycopy(gtrid, 0, xidxid, 0, gtrid_l);
                        System.arraycopy(bqual, 0, xidxid, gtrid_l, bqual_l);
                    }
                    int t4cflag = 0;
                    t4cflag = (flag & 8) != 0 ? (t4cflag |= 8) : ((flag & 0x200000) != 0 || (flag & 0x8000000) != 0 ? (t4cflag |= 4) : (t4cflag |= 1));
                    if ((flag & 0x100) != 0) {
                        t4cflag |= 0x100;
                    }
                    if ((flag & 0x200) != 0) {
                        t4cflag |= 0x200;
                    }
                    if ((flag & 0x400) != 0) {
                        t4cflag |= 0x400;
                    }
                    if ((flag & 0x10000) != 0) {
                        t4cflag |= 0x10000;
                    }
                    physicalConn.updateSystemContext();
                    physicalConn.needLine();
                    otxse.doOTXSE(1, null, xidxid, xid.getFormatId(), gtrid_l, bqual_l, this.timeout, t4cflag, this.applicationValueArr);
                    this.applicationValueArr[0] = otxse.getApplicationValue();
                    byte[] ctx = otxse.getContext();
                    if (ctx != null) {
                        this.context = ctx;
                    }
                    returnVal = 0;
                    physicalConn.currentlyInTransaction = true;
                }
                catch (IOException ioe) {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doStart", null, null, ioe);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioe).fillInStackTrace();
                }
            }
            catch (SQLException s) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doStart", null, null, s);
                returnVal = s.getErrorCode();
                if (returnVal == 0) {
                    throw new XAException(-6);
                }
                throw s;
            }
            int n = returnVal;
            return n;
        }
    }

    @Override
    protected int doEnd(Xid xid, int flag, boolean isLocallySuspended) throws XAException, SQLException {
        T4CConnection physicalConn = this.getT4CConnection();
        try (Monitor.CloseableLock lock = physicalConn.acquireCloseableLock();){
            int bqual_l;
            int gtrid_l;
            byte[] xidxid;
            T4CTTIOtxse otxse;
            int returnVal;
            block18: {
                returnVal = -1;
                otxse = physicalConn.otxse;
                xidxid = null;
                byte[] gtrid = xid.getGlobalTransactionId();
                byte[] bqual = xid.getBranchQualifier();
                gtrid_l = 0;
                bqual_l = 0;
                if (gtrid != null && bqual != null) {
                    gtrid_l = Math.min(gtrid.length, 64);
                    bqual_l = Math.min(bqual.length, 64);
                    xidxid = new byte[128];
                    System.arraycopy(gtrid, 0, xidxid, 0, gtrid_l);
                    System.arraycopy(bqual, 0, xidxid, gtrid_l, bqual_l);
                }
                if (this.context != null || (returnVal = this.doStart(xid, 0x8000000)) == 0) break block18;
                int n = returnVal;
                return n;
            }
            try {
                try {
                    byte[] txctx = this.context;
                    int t4cflag = 0;
                    if ((flag & 2) == 2) {
                        t4cflag = 0x100000;
                    } else if ((flag & 0x2000000) == 0x2000000 && (flag & 0x100000) != 0x100000) {
                        t4cflag = 0x100000;
                    }
                    this.applicationValueArr[0] = this.applicationValueArr[0] >> 16;
                    physicalConn.updateSystemContext();
                    physicalConn.needLine();
                    otxse.doOTXSE(2, txctx, xidxid, xid.getFormatId(), gtrid_l, bqual_l, this.timeout, t4cflag, this.applicationValueArr);
                    this.applicationValueArr[0] = otxse.getApplicationValue();
                    byte[] ctx = otxse.getContext();
                    if (ctx != null) {
                        this.context = ctx;
                    }
                    returnVal = 0;
                    physicalConn.currentlyInTransaction = false;
                }
                catch (IOException ioe) {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doEnd", null, null, ioe);
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioe).fillInStackTrace();
                }
            }
            catch (SQLException s) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doEnd", null, null, s);
                returnVal = s.getErrorCode();
                if (returnVal == 0) {
                    throw new XAException(-6);
                }
                throw s;
            }
            int n = returnVal;
            return n;
        }
    }

    @Override
    protected void doCommit(Xid xid, boolean onePhaseCommit) throws SQLException, XAException {
        block22: {
            T4CConnection physicalConn = this.getT4CConnection();
            try (Monitor.CloseableLock lock = physicalConn.acquireCloseableLock();){
                int inTransactionState = onePhaseCommit ? 4 : 2;
                try {
                    int outState = this.doTransaction(xid, 1, inTransactionState);
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doCommit", "server returns {0}", (String)null, null, (Object)outState);
                    if ((!onePhaseCommit || outState != 2 && outState != 4) && (onePhaseCommit || outState != 5)) {
                        if (outState == 8) {
                            throw new XAException(106);
                        }
                        throw new XAException(-6);
                    }
                    physicalConn.currentlyInTransaction = false;
                }
                catch (SQLException sqlex) {
                    int errorCode = sqlex.getErrorCode();
                    if (errorCode == 24756) {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "do_commit", "T4CXAResource.do_commit: got a 24756. Will try to recover.", null, null);
                        this.kputxrec(xid, 1, this.timeout + 120, sqlex);
                        break block22;
                    }
                    if (errorCode == 24780) {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "do_commit", "got a 24780. Will try to commit from a different connection.", null, null);
                        OracleXADataSource oxds = null;
                        PooledConnection pc = null;
                        try {
                            oxds = new OracleXADataSource();
                            oxds.setURL(physicalConn.url);
                            oxds.setUser(physicalConn.userName);
                            physicalConn.getPasswordInternal(this);
                            oxds.setPassword(this.password.get());
                            pc = oxds.getXAConnection();
                            XAResource oxar = pc.getXAResource();
                            oxar.commit(xid, onePhaseCommit);
                            physicalConn.currentlyInTransaction = false;
                            break block22;
                        }
                        catch (SQLException e) {
                            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "do_commit", "Got a SQLException while processing a 24780.", null, e);
                            XAException xaex = new XAException(-6);
                            xaex.initCause(e);
                            throw xaex;
                        }
                        finally {
                            try {
                                if (pc != null) {
                                    pc.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                    throw sqlex;
                }
            }
        }
    }

    @Override
    protected int doPrepare(Xid xid) throws XAException, SQLException {
        T4CConnection physicalConn = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
        try (Monitor.CloseableLock lock = physicalConn.acquireCloseableLock();){
            int returnVal;
            block13: {
                returnVal = -1;
                try {
                    int outState = this.doTransaction(xid, 3, 0);
                    if (outState == 8) {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doPrepare", "server returns K2CMDtimeout", null, null);
                        throw new XAException(106);
                    }
                    if (outState == 4) {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doPrepare", "server returns K2CMDrdonly", null, null);
                        returnVal = 3;
                        break block13;
                    }
                    if (outState == 1) {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doPrepare", "server returns K2CMDrqcommit", null, null);
                        returnVal = 0;
                        break block13;
                    }
                    if (outState == 3) {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doPrepare", "server returns K2CMDabort", null, null);
                        throw new XAException(100);
                    }
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doPrepare", "server returns {0}", (String)null, null, (Object)outState);
                    throw new XAException(-6);
                }
                catch (SQLException sqlex) {
                    int errorCode = sqlex.getErrorCode();
                    if (errorCode == 25351) {
                        XAException xae = new XAException(-6);
                        xae.initCause(sqlex);
                        throw xae;
                    }
                    throw sqlex;
                }
            }
            int n = returnVal;
            return n;
        }
    }

    @Override
    protected int doForget(Xid xid) throws XAException, SQLException {
        T4CConnection physicalConn = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
        try (Monitor.CloseableLock lock = physicalConn.acquireCloseableLock();){
            int resumeReturn;
            int returnVal = 0;
            SQLException sqlException = null;
            if (OracleXid.isLocalTransaction(xid)) {
                int n = 24771;
                return n;
            }
            try {
                resumeReturn = this.doStart(xid, 0x8000000);
            }
            catch (SQLException sqlex) {
                resumeReturn = sqlex.getErrorCode();
                sqlException = sqlex;
            }
            if (resumeReturn != 24756) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doForget", "resume returned : {0}", (String)null, null, (Object)resumeReturn);
                if (resumeReturn == 0) {
                    try {
                        this.doEnd(xid, 0, false);
                    }
                    catch (Exception e) {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doForget", null, null, e);
                    }
                }
                if (resumeReturn == 0 || resumeReturn == 2079 || resumeReturn == 24754 || resumeReturn == 24761 || resumeReturn == 24774 || resumeReturn == 24776 || resumeReturn == 25351) {
                    this.checkError(24769, sqlException);
                } else if (resumeReturn == 24752) {
                    this.checkError(24771, sqlException);
                } else {
                    this.checkError(resumeReturn, sqlException);
                }
                int n = returnVal;
                return n;
            }
            this.kputxrec(xid, 4, 1, null);
            int n = returnVal;
            return n;
        }
    }

    @Override
    protected void doRollback(Xid xid) throws XAException, SQLException {
        block23: {
            T4CConnection physicalConn = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
            try (Monitor.CloseableLock lock = physicalConn.acquireCloseableLock();){
                try {
                    int outState = this.doTransaction(xid, 2, 3);
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doRollback", "server returns {0}", (String)null, null, (Object)outState);
                    if (outState == 8) {
                        throw new XAException(106);
                    }
                    if (outState != 3) {
                        throw new XAException(-6);
                    }
                    physicalConn.currentlyInTransaction = false;
                }
                catch (SQLException sqle) {
                    int errorCode = sqle.getErrorCode();
                    if (errorCode == 24756) {
                        this.kputxrec(xid, 2, this.timeout + 120, sqle);
                        break block23;
                    }
                    if (errorCode == 24780) {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doRollback", "T4CXAResource.do_rollback: got a 24780.", null, null);
                        OracleXADataSource oxds = null;
                        PooledConnection pc = null;
                        try {
                            oxds = new OracleXADataSource();
                            oxds.setURL(physicalConn.url);
                            oxds.setUser(physicalConn.userName);
                            physicalConn.getPasswordInternal(this);
                            oxds.setPassword(this.password.get());
                            pc = oxds.getXAConnection();
                            XAResource oxar = pc.getXAResource();
                            oxar.rollback(xid);
                            physicalConn.currentlyInTransaction = false;
                            break block23;
                        }
                        catch (SQLException e) {
                            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doRollback", "Got a SQLException while processing a 24780.", null, e);
                            XAException xaex = new XAException(-6);
                            xaex.initCause(e);
                            throw xaex;
                        }
                        finally {
                            try {
                                if (pc != null) {
                                    pc.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (errorCode == 25402) {
                        break block23;
                    }
                    throw sqle;
                }
            }
        }
    }

    int doTransaction(Xid xid, int mode, int inTransactionState) throws SQLException {
        T4CConnection physicalConn = this.getT4CConnection();
        int transactionOutState = -1;
        try {
            T4CTTIOtxen otxen = physicalConn.otxen;
            byte[] xidxid = null;
            byte[] gtrid = xid.getGlobalTransactionId();
            byte[] bqual = xid.getBranchQualifier();
            int gtrid_l = 0;
            int bqual_l = 0;
            if (gtrid != null && bqual != null) {
                gtrid_l = Math.min(gtrid.length, 64);
                bqual_l = Math.min(bqual.length, 64);
                xidxid = new byte[128];
                System.arraycopy(gtrid, 0, xidxid, 0, gtrid_l);
                System.arraycopy(bqual, 0, xidxid, gtrid_l, bqual_l);
            }
            byte[] txctx = this.context;
            physicalConn.needLine();
            otxen.doOTXEN(mode, txctx, xidxid, xid.getFormatId(), gtrid_l, bqual_l, this.timeout, inTransactionState, 0);
            transactionOutState = otxen.getOutStateFromServer();
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doTransaction", "transactionOutState={0}", (String)null, null, (Object)transactionOutState);
        }
        catch (IOException ioe) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doTransaction", null, null, ioe);
            physicalConn.handleIOException(ioe);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioe).fillInStackTrace();
        }
        return transactionOutState;
    }

    protected void kputxrec(Xid xid, int opcode, int tries, SQLException sqlexCause) throws XAException, SQLException {
        int incmd;
        T4CConnection physicalConn = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
        int inTransactionMode = switch (opcode) {
            case 1 -> 3;
            case 4 -> 2;
            default -> 0;
        };
        int endstate = -1;
        while (tries-- > 0 && (endstate = this.doTransaction(xid, 5, inTransactionMode)) == 7) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        if (endstate == 7 || endstate == -1) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "kputxrec", "T4CXAResource.kputxrec: Try to recover but transaction operation cannot be completed now. Transaction not ready for recovery.", null, null);
            throw new XAException(-6);
        }
        int xaErrorCode = -1;
        int returnErrorCode = 0;
        switch (endstate) {
            case 3: {
                if (opcode == 1) {
                    incmd = 7;
                    break;
                }
                incmd = 8;
                xaErrorCode = -3;
                returnErrorCode = 24762;
                break;
            }
            case 0: {
                if (opcode == 4) {
                    incmd = 8;
                    xaErrorCode = -3;
                    returnErrorCode = 24762;
                    break;
                }
                incmd = 7;
                if (opcode != 1) break;
                xaErrorCode = -4;
                returnErrorCode = 24756;
                break;
            }
            case 5: {
                if (opcode == 4) {
                    incmd = 7;
                    break;
                }
                incmd = 8;
                xaErrorCode = 7;
                returnErrorCode = 24764;
                break;
            }
            case 4: {
                if (opcode == 4) {
                    incmd = 7;
                    break;
                }
                incmd = 8;
                xaErrorCode = 6;
                returnErrorCode = 24765;
                break;
            }
            case 6: {
                if (opcode == 4) {
                    incmd = 7;
                    break;
                }
                incmd = 8;
                xaErrorCode = 5;
                returnErrorCode = 24766;
                break;
            }
            case 2: {
                if (opcode == 4) {
                    incmd = 8;
                    xaErrorCode = -6;
                    returnErrorCode = 24770;
                    break;
                }
            }
            default: {
                incmd = 8;
                xaErrorCode = -3;
                returnErrorCode = 24762;
            }
        }
        T4CTTIk2rpc k2rpc = physicalConn.k2rpc;
        try {
            k2rpc.doOK2RPC(3, incmd);
        }
        catch (IOException ioe) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "kputxrec", null, null, ioe);
            XAException xae = new XAException(-7);
            xae.initCause(ioe);
            throw xae;
        }
        catch (SQLException s) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "kputxrec", null, null, s);
            XAException xar = new XAException(-6);
            xar.initCause(s);
            throw xar;
        }
        if (xaErrorCode != -1) {
            OracleXAException xae = null;
            if (sqlexCause != null && returnErrorCode == 0) {
                xae = new OracleXAException(sqlexCause.getErrorCode(), xaErrorCode);
                xae.initCause(sqlexCause);
            } else {
                xae = new OracleXAException(returnErrorCode, xaErrorCode);
            }
            throw xae;
        }
    }

    final void setPasswordInternal(OpaqueString p) {
        this.password = p;
    }

    private T4CConnection getT4CConnection() throws SQLException {
        if (this.connection instanceof AbstractTrueCacheConnection) {
            return (T4CConnection)this.connection.unwrap(OracleConnection.class);
        }
        if (this.connection instanceof ReplayableConnection) {
            return (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_();
        }
        return (T4CConnection)this.connection;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return (OracleConnection)this.connection;
    }
}

