/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import java.math.RoundingMode;

public class DecimalConfig {
    private final Integer precision;
    private final Integer scale;
    private final RoundingMode roundingMode;

    private DecimalConfig(Integer precision, Integer scale, RoundingMode roundingMode) {
        this.precision = precision;
        this.scale = scale;
        this.roundingMode = roundingMode;
    }

    public Integer precision() {
        return this.precision;
    }

    public Integer scale() {
        return this.scale;
    }

    public RoundingMode roundingMode() {
        return this.roundingMode;
    }

    public static DecimalConfig decimalConfig() {
        return new DecimalConfig(null, null, null);
    }

    public DecimalConfig withPrecisionAndScale(int precision, int scale) {
        if (precision <= 0) {
            throw new IllegalArgumentException("precision must be greater than 0");
        }
        if (scale < 0) {
            throw new IllegalArgumentException("scale must be zero or a positive value");
        }
        if (scale > precision) {
            throw new IllegalArgumentException("scale must be less than or equal to the precision");
        }
        return new DecimalConfig(precision, scale, this.roundingMode);
    }

    public DecimalConfig withRoundingMode(RoundingMode roundingMode) {
        return new DecimalConfig(this.precision, this.scale, roundingMode);
    }

    public boolean arePrecisionAndScaleConfigured() {
        return this.precision != null && this.scale != null;
    }
}

