/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.enhancer;

import com.google.appengine.tools.enhancer.Enhancer;
import com.google.appengine.tools.info.SdkImplInfo;
import com.google.appengine.tools.util.Logging;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enhance {
    public static void main(String[] args) {
        Logging.initializeLogging();
        new Enhance(args);
    }

    public Enhance(String[] args) {
        PrintWriter writer;
        File logFile = null;
        try {
            logFile = File.createTempFile("enhance", ".log");
            writer = new PrintWriter((Writer)new FileWriter(logFile), true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to enable logging.", e);
        }
        try {
            Set<URL> targets = this.getEnhanceTargets();
            Enhancer enhancer = new Enhancer();
            enhancer.setTargets(targets);
            enhancer.setArgs(args);
            enhancer.execute();
        }
        catch (Exception e) {
            System.out.println("Encountered a problem: " + e.getMessage());
            System.out.println("Please see the logs [" + logFile.getAbsolutePath() + "] for further information.");
            e.printStackTrace(writer);
            System.exit(1);
        }
    }

    private Set<URL> getEnhanceTargets() {
        URLClassLoader myLoader = (URLClassLoader)this.getClass().getClassLoader();
        URL[] urls = myLoader.getURLs();
        HashSet<URL> enhanceTargets = new HashSet<URL>(Arrays.asList(urls));
        URL toolsJar = SdkImplInfo.getToolsApiJar();
        for (URL url : enhanceTargets) {
            if (!url.sameFile(toolsJar)) continue;
            enhanceTargets.remove(toolsJar);
            break;
        }
        return enhanceTargets;
    }
}

