/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue.dev;

import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.api.taskqueue.dev.QueueStateInfo;
import com.google.apphosting.utils.config.QueueXml;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

abstract class DevQueue {
    protected static final Logger logger = Logger.getLogger(DevQueue.class.getName());
    protected final QueueXml.Entry queueXmlEntry;
    protected final AtomicInteger taskNameGenerator;

    DevQueue(QueueXml.Entry queueXmlEntry, AtomicInteger taskNameGenerator) {
        this.queueXmlEntry = queueXmlEntry;
        this.taskNameGenerator = taskNameGenerator;
    }

    String genTaskName() {
        Integer newId = this.taskNameGenerator.incrementAndGet();
        return "task" + newId.toString();
    }

    abstract TaskQueuePb.TaskQueueAddResponse add(TaskQueuePb.TaskQueueAddRequest var1);

    protected String getQueueName() {
        return this.queueXmlEntry.getName();
    }

    protected TaskQueuePb.TaskQueueRetryParameters getRetryParameters(TaskQueuePb.TaskQueueAddRequest addRequest) {
        if (addRequest.hasRetryParameters()) {
            return addRequest.getRetryParameters();
        }
        QueueXml.RetryParameters retryParams = this.queueXmlEntry.getRetryParameters();
        if (retryParams == null) {
            return null;
        }
        TaskQueuePb.TaskQueueRetryParameters paramsPb = new TaskQueuePb.TaskQueueRetryParameters();
        if (retryParams.getRetryLimit() != null) {
            paramsPb.setRetryLimit(retryParams.getRetryLimit().intValue());
        }
        if (retryParams.getAgeLimitSec() != null) {
            paramsPb.setAgeLimitSec((long)retryParams.getAgeLimitSec().intValue());
        }
        if (retryParams.getMinBackoffSec() != null) {
            paramsPb.setMinBackoffSec(retryParams.getMinBackoffSec().doubleValue());
        }
        if (retryParams.getMaxBackoffSec() != null) {
            paramsPb.setMaxBackoffSec(retryParams.getMaxBackoffSec().doubleValue());
        }
        if (retryParams.getMaxDoublings() != null) {
            paramsPb.setMaxDoublings(retryParams.getMaxDoublings().intValue());
        }
        return paramsPb;
    }

    abstract QueueStateInfo getStateInfo();

    abstract boolean deleteTask(String var1);

    abstract void flush();

    abstract TaskQueuePb.TaskQueueMode.Mode getMode();

    abstract boolean runTask(String var1);
}

