/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.convert;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.PeriodType;
import com.google.appengine.repackaged.org.joda.time.ReadablePartial;
import com.google.appengine.repackaged.org.joda.time.chrono.ISOChronology;
import com.google.appengine.repackaged.org.joda.time.convert.Converter;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormatter;

public abstract class AbstractConverter
implements Converter {
    protected AbstractConverter() {
    }

    public long getInstantMillis(Object object, Chronology chrono) {
        return DateTimeUtils.currentTimeMillis();
    }

    public Chronology getChronology(Object object, DateTimeZone zone) {
        return ISOChronology.getInstance(zone);
    }

    public Chronology getChronology(Object object, Chronology chrono) {
        return DateTimeUtils.getChronology(chrono);
    }

    public int[] getPartialValues(ReadablePartial fieldSource, Object object, Chronology chrono) {
        long instant = this.getInstantMillis(object, chrono);
        return chrono.get(fieldSource, instant);
    }

    public int[] getPartialValues(ReadablePartial fieldSource, Object object, Chronology chrono, DateTimeFormatter parser) {
        return this.getPartialValues(fieldSource, object, chrono);
    }

    public PeriodType getPeriodType(Object object) {
        return PeriodType.standard();
    }

    public boolean isReadableInterval(Object object, Chronology chrono) {
        return false;
    }

    public String toString() {
        return "Converter[" + (this.getSupportedType() == null ? "null" : this.getSupportedType().getName()) + "]";
    }
}

