/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.query;

import com.google.appengine.api.search.query.QueryLexer;
import com.google.appengine.api.search.query.QueryParser;
import com.google.appengine.api.search.query.QueryParserFactory;
import com.google.appengine.repackaged.org.antlr.runtime.ANTLRStringStream;
import com.google.appengine.repackaged.org.antlr.runtime.RecognitionException;
import com.google.appengine.repackaged.org.antlr.runtime.TokenRewriteStream;
import com.google.appengine.repackaged.org.antlr.runtime.tree.CommonTree;
import com.google.appengine.repackaged.org.antlr.runtime.tree.CommonTreeAdaptor;

public class QueryTreeBuilder {
    private static final ThreadLocal<QueryLexer> LEXER_POOL = new ThreadLocal<QueryLexer>(){

        @Override
        protected QueryLexer initialValue() {
            return new QueryLexer();
        }
    };
    private final QueryParserFactory parserFactory;
    private final CommonTreeAdaptor adaptor = new CommonTreeAdaptor();

    public QueryTreeBuilder() {
        this.parserFactory = new QueryParserFactory();
    }

    public QueryTreeBuilder(QueryParserFactory parserFactory) {
        this.parserFactory = parserFactory;
    }

    public CommonTree parse(String query) throws RecognitionException {
        if (query == null) {
            throw new NullPointerException("query must not be null");
        }
        String trimmed = query.trim();
        if (trimmed.isEmpty()) {
            return (CommonTree)this.adaptor.nil();
        }
        ANTLRStringStream stream = new ANTLRStringStream(query);
        QueryLexer lexer = LEXER_POOL.get();
        lexer.setCharStream(stream);
        TokenRewriteStream tokens = new TokenRewriteStream(lexer);
        QueryParser parser = this.parserFactory.newParser(tokens);
        return (CommonTree)parser.query().getTree();
    }
}

