/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Representative value of a single feature within the cluster.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FeatureValue extends com.google.api.client.json.GenericJson {

  /**
   * The categorical feature value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CategoricalValue categoricalValue;

  /**
   * The feature column name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String featureColumn;

  /**
   * The numerical feature value. This is the centroid value for this feature.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double numericalValue;

  /**
   * The categorical feature value.
   * @return value or {@code null} for none
   */
  public CategoricalValue getCategoricalValue() {
    return categoricalValue;
  }

  /**
   * The categorical feature value.
   * @param categoricalValue categoricalValue or {@code null} for none
   */
  public FeatureValue setCategoricalValue(CategoricalValue categoricalValue) {
    this.categoricalValue = categoricalValue;
    return this;
  }

  /**
   * The feature column name.
   * @return value or {@code null} for none
   */
  public java.lang.String getFeatureColumn() {
    return featureColumn;
  }

  /**
   * The feature column name.
   * @param featureColumn featureColumn or {@code null} for none
   */
  public FeatureValue setFeatureColumn(java.lang.String featureColumn) {
    this.featureColumn = featureColumn;
    return this;
  }

  /**
   * The numerical feature value. This is the centroid value for this feature.
   * @return value or {@code null} for none
   */
  public java.lang.Double getNumericalValue() {
    return numericalValue;
  }

  /**
   * The numerical feature value. This is the centroid value for this feature.
   * @param numericalValue numericalValue or {@code null} for none
   */
  public FeatureValue setNumericalValue(java.lang.Double numericalValue) {
    this.numericalValue = numericalValue;
    return this;
  }

  @Override
  public FeatureValue set(String fieldName, Object value) {
    return (FeatureValue) super.set(fieldName, value);
  }

  @Override
  public FeatureValue clone() {
    return (FeatureValue) super.clone();
  }

}
