/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.secretmanager.v1beta2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SecretName
implements ResourceName {
    private static final PathTemplate PROJECT_SECRET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/secrets/{secret}");
    private static final PathTemplate PROJECT_LOCATION_SECRET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/secrets/{secret}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String secret;
    private final String location;

    @Deprecated
    protected SecretName() {
        this.project = null;
        this.secret = null;
        this.location = null;
    }

    private SecretName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.secret = (String)Preconditions.checkNotNull((Object)builder.getSecret());
        this.location = null;
        this.pathTemplate = PROJECT_SECRET;
    }

    private SecretName(ProjectLocationSecretBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.secret = (String)Preconditions.checkNotNull((Object)builder.getSecret());
        this.pathTemplate = PROJECT_LOCATION_SECRET;
    }

    public String getProject() {
        return this.project;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectSecretBuilder() {
        return new Builder();
    }

    public static ProjectLocationSecretBuilder newProjectLocationSecretBuilder() {
        return new ProjectLocationSecretBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SecretName of(String project, String secret) {
        return SecretName.newBuilder().setProject(project).setSecret(secret).build();
    }

    public static SecretName ofProjectSecretName(String project, String secret) {
        return SecretName.newBuilder().setProject(project).setSecret(secret).build();
    }

    public static SecretName ofProjectLocationSecretName(String project, String location, String secret) {
        return SecretName.newProjectLocationSecretBuilder().setProject(project).setLocation(location).setSecret(secret).build();
    }

    public static String format(String project, String secret) {
        return SecretName.newBuilder().setProject(project).setSecret(secret).build().toString();
    }

    public static String formatProjectSecretName(String project, String secret) {
        return SecretName.newBuilder().setProject(project).setSecret(secret).build().toString();
    }

    public static String formatProjectLocationSecretName(String project, String location, String secret) {
        return SecretName.newProjectLocationSecretBuilder().setProject(project).setLocation(location).setSecret(secret).build().toString();
    }

    public static SecretName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_SECRET.matches(formattedString)) {
            Map matchMap = PROJECT_SECRET.match(formattedString);
            return SecretName.ofProjectSecretName((String)matchMap.get("project"), (String)matchMap.get("secret"));
        }
        if (PROJECT_LOCATION_SECRET.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_SECRET.match(formattedString);
            return SecretName.ofProjectLocationSecretName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("secret"));
        }
        throw new ValidationException("SecretName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SecretName> parseList(List<String> formattedStrings) {
        ArrayList<SecretName> list = new ArrayList<SecretName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SecretName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SecretName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SecretName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_SECRET.matches(formattedString) || PROJECT_LOCATION_SECRET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SecretName secretName = this;
            synchronized (secretName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.secret != null) {
                        fieldMapBuilder.put((Object)"secret", (Object)this.secret);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SecretName that = (SecretName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.secret, that.secret) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.secret);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class ProjectLocationSecretBuilder {
        private String project;
        private String location;
        private String secret;

        protected ProjectLocationSecretBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSecret() {
            return this.secret;
        }

        public ProjectLocationSecretBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationSecretBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationSecretBuilder setSecret(String secret) {
            this.secret = secret;
            return this;
        }

        public SecretName build() {
            return new SecretName(this);
        }
    }

    public static class Builder {
        private String project;
        private String secret;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getSecret() {
            return this.secret;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSecret(String secret) {
            this.secret = secret;
            return this;
        }

        private Builder(SecretName secretName) {
            Preconditions.checkArgument((boolean)Objects.equals(secretName.pathTemplate, PROJECT_SECRET), (Object)"toBuilder is only supported when SecretName has the pattern of projects/{project}/secrets/{secret}");
            this.project = secretName.project;
            this.secret = secretName.secret;
        }

        public SecretName build() {
            return new SecretName(this);
        }
    }
}

