/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/batch/v1/task.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.batch.v1;

/**
 *
 *
 * <pre>
 * LifecyclePolicy describes how to deal with task failures
 * based on different conditions.
 * </pre>
 *
 * Protobuf type {@code google.cloud.batch.v1.LifecyclePolicy}
 */
public final class LifecyclePolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.batch.v1.LifecyclePolicy)
    LifecyclePolicyOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use LifecyclePolicy.newBuilder() to construct.
  private LifecyclePolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LifecyclePolicy() {
    action_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LifecyclePolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.batch.v1.TaskProto
        .internal_static_google_cloud_batch_v1_LifecyclePolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.batch.v1.TaskProto
        .internal_static_google_cloud_batch_v1_LifecyclePolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.batch.v1.LifecyclePolicy.class,
            com.google.cloud.batch.v1.LifecyclePolicy.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Action on task failures based on different conditions.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.batch.v1.LifecyclePolicy.Action}
   */
  public enum Action implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Action unspecified.
     * </pre>
     *
     * <code>ACTION_UNSPECIFIED = 0;</code>
     */
    ACTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Action that tasks in the group will be scheduled to re-execute.
     * </pre>
     *
     * <code>RETRY_TASK = 1;</code>
     */
    RETRY_TASK(1),
    /**
     *
     *
     * <pre>
     * Action that tasks in the group will be stopped immediately.
     * </pre>
     *
     * <code>FAIL_TASK = 2;</code>
     */
    FAIL_TASK(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Action unspecified.
     * </pre>
     *
     * <code>ACTION_UNSPECIFIED = 0;</code>
     */
    public static final int ACTION_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Action that tasks in the group will be scheduled to re-execute.
     * </pre>
     *
     * <code>RETRY_TASK = 1;</code>
     */
    public static final int RETRY_TASK_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Action that tasks in the group will be stopped immediately.
     * </pre>
     *
     * <code>FAIL_TASK = 2;</code>
     */
    public static final int FAIL_TASK_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Action valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Action forNumber(int value) {
      switch (value) {
        case 0:
          return ACTION_UNSPECIFIED;
        case 1:
          return RETRY_TASK;
        case 2:
          return FAIL_TASK;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Action> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Action> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Action>() {
          public Action findValueByNumber(int number) {
            return Action.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.batch.v1.LifecyclePolicy.getDescriptor().getEnumTypes().get(0);
    }

    private static final Action[] VALUES = values();

    public static Action valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Action(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.batch.v1.LifecyclePolicy.Action)
  }

  public interface ActionConditionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.batch.v1.LifecyclePolicy.ActionCondition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Exit codes of a task execution.
     * If there are more than 1 exit codes,
     * when task executes with any of the exit code in the list,
     * the condition is met and the action will be executed.
     * </pre>
     *
     * <code>repeated int32 exit_codes = 1;</code>
     *
     * @return A list containing the exitCodes.
     */
    java.util.List<java.lang.Integer> getExitCodesList();

    /**
     *
     *
     * <pre>
     * Exit codes of a task execution.
     * If there are more than 1 exit codes,
     * when task executes with any of the exit code in the list,
     * the condition is met and the action will be executed.
     * </pre>
     *
     * <code>repeated int32 exit_codes = 1;</code>
     *
     * @return The count of exitCodes.
     */
    int getExitCodesCount();

    /**
     *
     *
     * <pre>
     * Exit codes of a task execution.
     * If there are more than 1 exit codes,
     * when task executes with any of the exit code in the list,
     * the condition is met and the action will be executed.
     * </pre>
     *
     * <code>repeated int32 exit_codes = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The exitCodes at the given index.
     */
    int getExitCodes(int index);
  }

  /**
   *
   *
   * <pre>
   * Conditions for actions to deal with task failures.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1.LifecyclePolicy.ActionCondition}
   */
  public static final class ActionCondition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.batch.v1.LifecyclePolicy.ActionCondition)
      ActionConditionOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ActionCondition.newBuilder() to construct.
    private ActionCondition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ActionCondition() {
      exitCodes_ = emptyIntList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ActionCondition();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1.TaskProto
          .internal_static_google_cloud_batch_v1_LifecyclePolicy_ActionCondition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1.TaskProto
          .internal_static_google_cloud_batch_v1_LifecyclePolicy_ActionCondition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition.class,
              com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition.Builder.class);
    }

    public static final int EXIT_CODES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.Internal.IntList exitCodes_ = emptyIntList();

    /**
     *
     *
     * <pre>
     * Exit codes of a task execution.
     * If there are more than 1 exit codes,
     * when task executes with any of the exit code in the list,
     * the condition is met and the action will be executed.
     * </pre>
     *
     * <code>repeated int32 exit_codes = 1;</code>
     *
     * @return A list containing the exitCodes.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getExitCodesList() {
      return exitCodes_;
    }

    /**
     *
     *
     * <pre>
     * Exit codes of a task execution.
     * If there are more than 1 exit codes,
     * when task executes with any of the exit code in the list,
     * the condition is met and the action will be executed.
     * </pre>
     *
     * <code>repeated int32 exit_codes = 1;</code>
     *
     * @return The count of exitCodes.
     */
    public int getExitCodesCount() {
      return exitCodes_.size();
    }

    /**
     *
     *
     * <pre>
     * Exit codes of a task execution.
     * If there are more than 1 exit codes,
     * when task executes with any of the exit code in the list,
     * the condition is met and the action will be executed.
     * </pre>
     *
     * <code>repeated int32 exit_codes = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The exitCodes at the given index.
     */
    public int getExitCodes(int index) {
      return exitCodes_.getInt(index);
    }

    private int exitCodesMemoizedSerializedSize = -1;

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (getExitCodesList().size() > 0) {
        output.writeUInt32NoTag(10);
        output.writeUInt32NoTag(exitCodesMemoizedSerializedSize);
      }
      for (int i = 0; i < exitCodes_.size(); i++) {
        output.writeInt32NoTag(exitCodes_.getInt(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < exitCodes_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(exitCodes_.getInt(i));
        }
        size += dataSize;
        if (!getExitCodesList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
        }
        exitCodesMemoizedSerializedSize = dataSize;
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition)) {
        return super.equals(obj);
      }
      com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition other =
          (com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition) obj;

      if (!getExitCodesList().equals(other.getExitCodesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getExitCodesCount() > 0) {
        hash = (37 * hash) + EXIT_CODES_FIELD_NUMBER;
        hash = (53 * hash) + getExitCodesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Conditions for actions to deal with task failures.
     * </pre>
     *
     * Protobuf type {@code google.cloud.batch.v1.LifecyclePolicy.ActionCondition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1.LifecyclePolicy.ActionCondition)
        com.google.cloud.batch.v1.LifecyclePolicy.ActionConditionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.batch.v1.TaskProto
            .internal_static_google_cloud_batch_v1_LifecyclePolicy_ActionCondition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.batch.v1.TaskProto
            .internal_static_google_cloud_batch_v1_LifecyclePolicy_ActionCondition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition.class,
                com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition.Builder.class);
      }

      // Construct using com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        exitCodes_ = emptyIntList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.batch.v1.TaskProto
            .internal_static_google_cloud_batch_v1_LifecyclePolicy_ActionCondition_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition getDefaultInstanceForType() {
        return com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition build() {
        com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition buildPartial() {
        com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition result =
            new com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          exitCodes_.makeImmutable();
          result.exitCodes_ = exitCodes_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition) {
          return mergeFrom((com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition other) {
        if (other == com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition.getDefaultInstance())
          return this;
        if (!other.exitCodes_.isEmpty()) {
          if (exitCodes_.isEmpty()) {
            exitCodes_ = other.exitCodes_;
            exitCodes_.makeImmutable();
            bitField0_ |= 0x00000001;
          } else {
            ensureExitCodesIsMutable();
            exitCodes_.addAll(other.exitCodes_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  int v = input.readInt32();
                  ensureExitCodesIsMutable();
                  exitCodes_.addInt(v);
                  break;
                } // case 8
              case 10:
                {
                  int length = input.readRawVarint32();
                  int limit = input.pushLimit(length);
                  ensureExitCodesIsMutable();
                  while (input.getBytesUntilLimit() > 0) {
                    exitCodes_.addInt(input.readInt32());
                  }
                  input.popLimit(limit);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Internal.IntList exitCodes_ = emptyIntList();

      private void ensureExitCodesIsMutable() {
        if (!exitCodes_.isModifiable()) {
          exitCodes_ = makeMutableCopy(exitCodes_);
        }
        bitField0_ |= 0x00000001;
      }

      /**
       *
       *
       * <pre>
       * Exit codes of a task execution.
       * If there are more than 1 exit codes,
       * when task executes with any of the exit code in the list,
       * the condition is met and the action will be executed.
       * </pre>
       *
       * <code>repeated int32 exit_codes = 1;</code>
       *
       * @return A list containing the exitCodes.
       */
      public java.util.List<java.lang.Integer> getExitCodesList() {
        exitCodes_.makeImmutable();
        return exitCodes_;
      }

      /**
       *
       *
       * <pre>
       * Exit codes of a task execution.
       * If there are more than 1 exit codes,
       * when task executes with any of the exit code in the list,
       * the condition is met and the action will be executed.
       * </pre>
       *
       * <code>repeated int32 exit_codes = 1;</code>
       *
       * @return The count of exitCodes.
       */
      public int getExitCodesCount() {
        return exitCodes_.size();
      }

      /**
       *
       *
       * <pre>
       * Exit codes of a task execution.
       * If there are more than 1 exit codes,
       * when task executes with any of the exit code in the list,
       * the condition is met and the action will be executed.
       * </pre>
       *
       * <code>repeated int32 exit_codes = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The exitCodes at the given index.
       */
      public int getExitCodes(int index) {
        return exitCodes_.getInt(index);
      }

      /**
       *
       *
       * <pre>
       * Exit codes of a task execution.
       * If there are more than 1 exit codes,
       * when task executes with any of the exit code in the list,
       * the condition is met and the action will be executed.
       * </pre>
       *
       * <code>repeated int32 exit_codes = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The exitCodes to set.
       * @return This builder for chaining.
       */
      public Builder setExitCodes(int index, int value) {

        ensureExitCodesIsMutable();
        exitCodes_.setInt(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Exit codes of a task execution.
       * If there are more than 1 exit codes,
       * when task executes with any of the exit code in the list,
       * the condition is met and the action will be executed.
       * </pre>
       *
       * <code>repeated int32 exit_codes = 1;</code>
       *
       * @param value The exitCodes to add.
       * @return This builder for chaining.
       */
      public Builder addExitCodes(int value) {

        ensureExitCodesIsMutable();
        exitCodes_.addInt(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Exit codes of a task execution.
       * If there are more than 1 exit codes,
       * when task executes with any of the exit code in the list,
       * the condition is met and the action will be executed.
       * </pre>
       *
       * <code>repeated int32 exit_codes = 1;</code>
       *
       * @param values The exitCodes to add.
       * @return This builder for chaining.
       */
      public Builder addAllExitCodes(java.lang.Iterable<? extends java.lang.Integer> values) {
        ensureExitCodesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, exitCodes_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Exit codes of a task execution.
       * If there are more than 1 exit codes,
       * when task executes with any of the exit code in the list,
       * the condition is met and the action will be executed.
       * </pre>
       *
       * <code>repeated int32 exit_codes = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExitCodes() {
        exitCodes_ = emptyIntList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1.LifecyclePolicy.ActionCondition)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.batch.v1.LifecyclePolicy.ActionCondition)
    private static final com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition();
    }

    public static com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ActionCondition> PARSER =
        new com.google.protobuf.AbstractParser<ActionCondition>() {
          @java.lang.Override
          public ActionCondition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ActionCondition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ActionCondition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int ACTION_FIELD_NUMBER = 1;
  private int action_ = 0;

  /**
   *
   *
   * <pre>
   * Action to execute when ActionCondition is true.
   * When RETRY_TASK is specified, we will retry failed tasks
   * if we notice any exit code match and fail tasks if no match is found.
   * Likewise, when FAIL_TASK is specified, we will fail tasks
   * if we notice any exit code match and retry tasks if no match is found.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.LifecyclePolicy.Action action = 1;</code>
   *
   * @return The enum numeric value on the wire for action.
   */
  @java.lang.Override
  public int getActionValue() {
    return action_;
  }

  /**
   *
   *
   * <pre>
   * Action to execute when ActionCondition is true.
   * When RETRY_TASK is specified, we will retry failed tasks
   * if we notice any exit code match and fail tasks if no match is found.
   * Likewise, when FAIL_TASK is specified, we will fail tasks
   * if we notice any exit code match and retry tasks if no match is found.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.LifecyclePolicy.Action action = 1;</code>
   *
   * @return The action.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.LifecyclePolicy.Action getAction() {
    com.google.cloud.batch.v1.LifecyclePolicy.Action result =
        com.google.cloud.batch.v1.LifecyclePolicy.Action.forNumber(action_);
    return result == null ? com.google.cloud.batch.v1.LifecyclePolicy.Action.UNRECOGNIZED : result;
  }

  public static final int ACTION_CONDITION_FIELD_NUMBER = 2;
  private com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition actionCondition_;

  /**
   *
   *
   * <pre>
   * Conditions that decide why a task failure is dealt with a specific action.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.LifecyclePolicy.ActionCondition action_condition = 2;</code>
   *
   * @return Whether the actionCondition field is set.
   */
  @java.lang.Override
  public boolean hasActionCondition() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Conditions that decide why a task failure is dealt with a specific action.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.LifecyclePolicy.ActionCondition action_condition = 2;</code>
   *
   * @return The actionCondition.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition getActionCondition() {
    return actionCondition_ == null
        ? com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition.getDefaultInstance()
        : actionCondition_;
  }

  /**
   *
   *
   * <pre>
   * Conditions that decide why a task failure is dealt with a specific action.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.LifecyclePolicy.ActionCondition action_condition = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.LifecyclePolicy.ActionConditionOrBuilder
      getActionConditionOrBuilder() {
    return actionCondition_ == null
        ? com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition.getDefaultInstance()
        : actionCondition_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (action_
        != com.google.cloud.batch.v1.LifecyclePolicy.Action.ACTION_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, action_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getActionCondition());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (action_
        != com.google.cloud.batch.v1.LifecyclePolicy.Action.ACTION_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, action_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getActionCondition());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.batch.v1.LifecyclePolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.batch.v1.LifecyclePolicy other =
        (com.google.cloud.batch.v1.LifecyclePolicy) obj;

    if (action_ != other.action_) return false;
    if (hasActionCondition() != other.hasActionCondition()) return false;
    if (hasActionCondition()) {
      if (!getActionCondition().equals(other.getActionCondition())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ACTION_FIELD_NUMBER;
    hash = (53 * hash) + action_;
    if (hasActionCondition()) {
      hash = (37 * hash) + ACTION_CONDITION_FIELD_NUMBER;
      hash = (53 * hash) + getActionCondition().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.batch.v1.LifecyclePolicy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1.LifecyclePolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.LifecyclePolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1.LifecyclePolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.LifecyclePolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1.LifecyclePolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.LifecyclePolicy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1.LifecyclePolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.LifecyclePolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1.LifecyclePolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.LifecyclePolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1.LifecyclePolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.batch.v1.LifecyclePolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * LifecyclePolicy describes how to deal with task failures
   * based on different conditions.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1.LifecyclePolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1.LifecyclePolicy)
      com.google.cloud.batch.v1.LifecyclePolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1.TaskProto
          .internal_static_google_cloud_batch_v1_LifecyclePolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1.TaskProto
          .internal_static_google_cloud_batch_v1_LifecyclePolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1.LifecyclePolicy.class,
              com.google.cloud.batch.v1.LifecyclePolicy.Builder.class);
    }

    // Construct using com.google.cloud.batch.v1.LifecyclePolicy.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getActionConditionFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      action_ = 0;
      actionCondition_ = null;
      if (actionConditionBuilder_ != null) {
        actionConditionBuilder_.dispose();
        actionConditionBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.batch.v1.TaskProto
          .internal_static_google_cloud_batch_v1_LifecyclePolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.LifecyclePolicy getDefaultInstanceForType() {
      return com.google.cloud.batch.v1.LifecyclePolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.LifecyclePolicy build() {
      com.google.cloud.batch.v1.LifecyclePolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.LifecyclePolicy buildPartial() {
      com.google.cloud.batch.v1.LifecyclePolicy result =
          new com.google.cloud.batch.v1.LifecyclePolicy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.batch.v1.LifecyclePolicy result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.action_ = action_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.actionCondition_ =
            actionConditionBuilder_ == null ? actionCondition_ : actionConditionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.batch.v1.LifecyclePolicy) {
        return mergeFrom((com.google.cloud.batch.v1.LifecyclePolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.batch.v1.LifecyclePolicy other) {
      if (other == com.google.cloud.batch.v1.LifecyclePolicy.getDefaultInstance()) return this;
      if (other.action_ != 0) {
        setActionValue(other.getActionValue());
      }
      if (other.hasActionCondition()) {
        mergeActionCondition(other.getActionCondition());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                action_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(getActionConditionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int action_ = 0;

    /**
     *
     *
     * <pre>
     * Action to execute when ActionCondition is true.
     * When RETRY_TASK is specified, we will retry failed tasks
     * if we notice any exit code match and fail tasks if no match is found.
     * Likewise, when FAIL_TASK is specified, we will fail tasks
     * if we notice any exit code match and retry tasks if no match is found.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LifecyclePolicy.Action action = 1;</code>
     *
     * @return The enum numeric value on the wire for action.
     */
    @java.lang.Override
    public int getActionValue() {
      return action_;
    }

    /**
     *
     *
     * <pre>
     * Action to execute when ActionCondition is true.
     * When RETRY_TASK is specified, we will retry failed tasks
     * if we notice any exit code match and fail tasks if no match is found.
     * Likewise, when FAIL_TASK is specified, we will fail tasks
     * if we notice any exit code match and retry tasks if no match is found.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LifecyclePolicy.Action action = 1;</code>
     *
     * @param value The enum numeric value on the wire for action to set.
     * @return This builder for chaining.
     */
    public Builder setActionValue(int value) {
      action_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Action to execute when ActionCondition is true.
     * When RETRY_TASK is specified, we will retry failed tasks
     * if we notice any exit code match and fail tasks if no match is found.
     * Likewise, when FAIL_TASK is specified, we will fail tasks
     * if we notice any exit code match and retry tasks if no match is found.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LifecyclePolicy.Action action = 1;</code>
     *
     * @return The action.
     */
    @java.lang.Override
    public com.google.cloud.batch.v1.LifecyclePolicy.Action getAction() {
      com.google.cloud.batch.v1.LifecyclePolicy.Action result =
          com.google.cloud.batch.v1.LifecyclePolicy.Action.forNumber(action_);
      return result == null
          ? com.google.cloud.batch.v1.LifecyclePolicy.Action.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Action to execute when ActionCondition is true.
     * When RETRY_TASK is specified, we will retry failed tasks
     * if we notice any exit code match and fail tasks if no match is found.
     * Likewise, when FAIL_TASK is specified, we will fail tasks
     * if we notice any exit code match and retry tasks if no match is found.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LifecyclePolicy.Action action = 1;</code>
     *
     * @param value The action to set.
     * @return This builder for chaining.
     */
    public Builder setAction(com.google.cloud.batch.v1.LifecyclePolicy.Action value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      action_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Action to execute when ActionCondition is true.
     * When RETRY_TASK is specified, we will retry failed tasks
     * if we notice any exit code match and fail tasks if no match is found.
     * Likewise, when FAIL_TASK is specified, we will fail tasks
     * if we notice any exit code match and retry tasks if no match is found.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LifecyclePolicy.Action action = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAction() {
      bitField0_ = (bitField0_ & ~0x00000001);
      action_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition actionCondition_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition,
            com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition.Builder,
            com.google.cloud.batch.v1.LifecyclePolicy.ActionConditionOrBuilder>
        actionConditionBuilder_;

    /**
     *
     *
     * <pre>
     * Conditions that decide why a task failure is dealt with a specific action.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LifecyclePolicy.ActionCondition action_condition = 2;</code>
     *
     * @return Whether the actionCondition field is set.
     */
    public boolean hasActionCondition() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Conditions that decide why a task failure is dealt with a specific action.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LifecyclePolicy.ActionCondition action_condition = 2;</code>
     *
     * @return The actionCondition.
     */
    public com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition getActionCondition() {
      if (actionConditionBuilder_ == null) {
        return actionCondition_ == null
            ? com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition.getDefaultInstance()
            : actionCondition_;
      } else {
        return actionConditionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Conditions that decide why a task failure is dealt with a specific action.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LifecyclePolicy.ActionCondition action_condition = 2;</code>
     */
    public Builder setActionCondition(
        com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition value) {
      if (actionConditionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        actionCondition_ = value;
      } else {
        actionConditionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Conditions that decide why a task failure is dealt with a specific action.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LifecyclePolicy.ActionCondition action_condition = 2;</code>
     */
    public Builder setActionCondition(
        com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition.Builder builderForValue) {
      if (actionConditionBuilder_ == null) {
        actionCondition_ = builderForValue.build();
      } else {
        actionConditionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Conditions that decide why a task failure is dealt with a specific action.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LifecyclePolicy.ActionCondition action_condition = 2;</code>
     */
    public Builder mergeActionCondition(
        com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition value) {
      if (actionConditionBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && actionCondition_ != null
            && actionCondition_
                != com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition.getDefaultInstance()) {
          getActionConditionBuilder().mergeFrom(value);
        } else {
          actionCondition_ = value;
        }
      } else {
        actionConditionBuilder_.mergeFrom(value);
      }
      if (actionCondition_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Conditions that decide why a task failure is dealt with a specific action.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LifecyclePolicy.ActionCondition action_condition = 2;</code>
     */
    public Builder clearActionCondition() {
      bitField0_ = (bitField0_ & ~0x00000002);
      actionCondition_ = null;
      if (actionConditionBuilder_ != null) {
        actionConditionBuilder_.dispose();
        actionConditionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Conditions that decide why a task failure is dealt with a specific action.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LifecyclePolicy.ActionCondition action_condition = 2;</code>
     */
    public com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition.Builder
        getActionConditionBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getActionConditionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Conditions that decide why a task failure is dealt with a specific action.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LifecyclePolicy.ActionCondition action_condition = 2;</code>
     */
    public com.google.cloud.batch.v1.LifecyclePolicy.ActionConditionOrBuilder
        getActionConditionOrBuilder() {
      if (actionConditionBuilder_ != null) {
        return actionConditionBuilder_.getMessageOrBuilder();
      } else {
        return actionCondition_ == null
            ? com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition.getDefaultInstance()
            : actionCondition_;
      }
    }

    /**
     *
     *
     * <pre>
     * Conditions that decide why a task failure is dealt with a specific action.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LifecyclePolicy.ActionCondition action_condition = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition,
            com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition.Builder,
            com.google.cloud.batch.v1.LifecyclePolicy.ActionConditionOrBuilder>
        getActionConditionFieldBuilder() {
      if (actionConditionBuilder_ == null) {
        actionConditionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition,
                com.google.cloud.batch.v1.LifecyclePolicy.ActionCondition.Builder,
                com.google.cloud.batch.v1.LifecyclePolicy.ActionConditionOrBuilder>(
                getActionCondition(), getParentForChildren(), isClean());
        actionCondition_ = null;
      }
      return actionConditionBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1.LifecyclePolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.batch.v1.LifecyclePolicy)
  private static final com.google.cloud.batch.v1.LifecyclePolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.batch.v1.LifecyclePolicy();
  }

  public static com.google.cloud.batch.v1.LifecyclePolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LifecyclePolicy> PARSER =
      new com.google.protobuf.AbstractParser<LifecyclePolicy>() {
        @java.lang.Override
        public LifecyclePolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LifecyclePolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LifecyclePolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.batch.v1.LifecyclePolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
