/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/batch/v1/job.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.batch.v1;

/**
 *
 *
 * <pre>
 * The Cloud Batch Job description.
 * </pre>
 *
 * Protobuf type {@code google.cloud.batch.v1.Job}
 */
public final class Job extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.batch.v1.Job)
    JobOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Job.newBuilder() to construct.
  private Job(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Job() {
    name_ = "";
    uid_ = "";
    taskGroups_ = java.util.Collections.emptyList();
    notifications_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Job();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.batch.v1.JobProto.internal_static_google_cloud_batch_v1_Job_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 8:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.batch.v1.JobProto
        .internal_static_google_cloud_batch_v1_Job_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.batch.v1.Job.class, com.google.cloud.batch.v1.Job.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Job name.
   * For example: "projects/123456/locations/us-central1/jobs/job01".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Job name.
   * For example: "projects/123456/locations/us-central1/jobs/job01".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";

  /**
   *
   *
   * <pre>
   * Output only. A system generated unique ID for the Job.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. A system generated unique ID for the Job.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRIORITY_FIELD_NUMBER = 3;
  private long priority_ = 0L;

  /**
   *
   *
   * <pre>
   * Priority of the Job.
   * The valid value range is [0, 100). Default value is 0.
   * Higher value indicates higher priority.
   * A job with higher priority value is more likely to run earlier if all other
   * requirements are satisfied.
   * </pre>
   *
   * <code>int64 priority = 3;</code>
   *
   * @return The priority.
   */
  @java.lang.Override
  public long getPriority() {
    return priority_;
  }

  public static final int TASK_GROUPS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.batch.v1.TaskGroup> taskGroups_;

  /**
   *
   *
   * <pre>
   * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.batch.v1.TaskGroup> getTaskGroupsList() {
    return taskGroups_;
  }

  /**
   *
   *
   * <pre>
   * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.batch.v1.TaskGroupOrBuilder>
      getTaskGroupsOrBuilderList() {
    return taskGroups_;
  }

  /**
   *
   *
   * <pre>
   * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getTaskGroupsCount() {
    return taskGroups_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.TaskGroup getTaskGroups(int index) {
    return taskGroups_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.TaskGroupOrBuilder getTaskGroupsOrBuilder(int index) {
    return taskGroups_.get(index);
  }

  public static final int ALLOCATION_POLICY_FIELD_NUMBER = 7;
  private com.google.cloud.batch.v1.AllocationPolicy allocationPolicy_;

  /**
   *
   *
   * <pre>
   * Compute resource allocation for all TaskGroups in the Job.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.AllocationPolicy allocation_policy = 7;</code>
   *
   * @return Whether the allocationPolicy field is set.
   */
  @java.lang.Override
  public boolean hasAllocationPolicy() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Compute resource allocation for all TaskGroups in the Job.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.AllocationPolicy allocation_policy = 7;</code>
   *
   * @return The allocationPolicy.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.AllocationPolicy getAllocationPolicy() {
    return allocationPolicy_ == null
        ? com.google.cloud.batch.v1.AllocationPolicy.getDefaultInstance()
        : allocationPolicy_;
  }

  /**
   *
   *
   * <pre>
   * Compute resource allocation for all TaskGroups in the Job.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.AllocationPolicy allocation_policy = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.AllocationPolicyOrBuilder getAllocationPolicyOrBuilder() {
    return allocationPolicy_ == null
        ? com.google.cloud.batch.v1.AllocationPolicy.getDefaultInstance()
        : allocationPolicy_;
  }

  public static final int LABELS_FIELD_NUMBER = 8;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.batch.v1.JobProto
                .internal_static_google_cloud_batch_v1_Job_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Custom labels to apply to the job and any Cloud Logging
   * [LogEntry](https://cloud.google.com/logging/docs/reference/v2/rest/v2/LogEntry)
   * that it generates.
   *
   * Use labels to group and describe the resources they are applied to. Batch
   * automatically applies predefined labels and supports multiple `labels`
   * fields for each job, which each let you apply custom labels to various
   * resources. Label names that start with "goog-" or "google-" are
   * reserved for predefined labels. For more information about labels with
   * Batch, see
   * [Organize resources using
   * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Custom labels to apply to the job and any Cloud Logging
   * [LogEntry](https://cloud.google.com/logging/docs/reference/v2/rest/v2/LogEntry)
   * that it generates.
   *
   * Use labels to group and describe the resources they are applied to. Batch
   * automatically applies predefined labels and supports multiple `labels`
   * fields for each job, which each let you apply custom labels to various
   * resources. Label names that start with "goog-" or "google-" are
   * reserved for predefined labels. For more information about labels with
   * Batch, see
   * [Organize resources using
   * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Custom labels to apply to the job and any Cloud Logging
   * [LogEntry](https://cloud.google.com/logging/docs/reference/v2/rest/v2/LogEntry)
   * that it generates.
   *
   * Use labels to group and describe the resources they are applied to. Batch
   * automatically applies predefined labels and supports multiple `labels`
   * fields for each job, which each let you apply custom labels to various
   * resources. Label names that start with "goog-" or "google-" are
   * reserved for predefined labels. For more information about labels with
   * Batch, see
   * [Organize resources using
   * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Custom labels to apply to the job and any Cloud Logging
   * [LogEntry](https://cloud.google.com/logging/docs/reference/v2/rest/v2/LogEntry)
   * that it generates.
   *
   * Use labels to group and describe the resources they are applied to. Batch
   * automatically applies predefined labels and supports multiple `labels`
   * fields for each job, which each let you apply custom labels to various
   * resources. Label names that start with "goog-" or "google-" are
   * reserved for predefined labels. For more information about labels with
   * Batch, see
   * [Organize resources using
   * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int STATUS_FIELD_NUMBER = 9;
  private com.google.cloud.batch.v1.JobStatus status_;

  /**
   *
   *
   * <pre>
   * Output only. Job status. It is read only for users.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.JobStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Job status. It is read only for users.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.JobStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.JobStatus getStatus() {
    return status_ == null ? com.google.cloud.batch.v1.JobStatus.getDefaultInstance() : status_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Job status. It is read only for users.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.JobStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.JobStatusOrBuilder getStatusOrBuilder() {
    return status_ == null ? com.google.cloud.batch.v1.JobStatus.getDefaultInstance() : status_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. When the Job was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. When the Job was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. When the Job was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. The last time the Job was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The last time the Job was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The last time the Job was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LOGS_POLICY_FIELD_NUMBER = 13;
  private com.google.cloud.batch.v1.LogsPolicy logsPolicy_;

  /**
   *
   *
   * <pre>
   * Log preservation policy for the Job.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.LogsPolicy logs_policy = 13;</code>
   *
   * @return Whether the logsPolicy field is set.
   */
  @java.lang.Override
  public boolean hasLogsPolicy() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Log preservation policy for the Job.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.LogsPolicy logs_policy = 13;</code>
   *
   * @return The logsPolicy.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.LogsPolicy getLogsPolicy() {
    return logsPolicy_ == null
        ? com.google.cloud.batch.v1.LogsPolicy.getDefaultInstance()
        : logsPolicy_;
  }

  /**
   *
   *
   * <pre>
   * Log preservation policy for the Job.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.LogsPolicy logs_policy = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.LogsPolicyOrBuilder getLogsPolicyOrBuilder() {
    return logsPolicy_ == null
        ? com.google.cloud.batch.v1.LogsPolicy.getDefaultInstance()
        : logsPolicy_;
  }

  public static final int NOTIFICATIONS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.batch.v1.JobNotification> notifications_;

  /**
   *
   *
   * <pre>
   * Notification configurations.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.batch.v1.JobNotification> getNotificationsList() {
    return notifications_;
  }

  /**
   *
   *
   * <pre>
   * Notification configurations.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.batch.v1.JobNotificationOrBuilder>
      getNotificationsOrBuilderList() {
    return notifications_;
  }

  /**
   *
   *
   * <pre>
   * Notification configurations.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
   */
  @java.lang.Override
  public int getNotificationsCount() {
    return notifications_.size();
  }

  /**
   *
   *
   * <pre>
   * Notification configurations.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.JobNotification getNotifications(int index) {
    return notifications_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Notification configurations.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.JobNotificationOrBuilder getNotificationsOrBuilder(int index) {
    return notifications_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uid_);
    }
    if (priority_ != 0L) {
      output.writeInt64(3, priority_);
    }
    for (int i = 0; i < taskGroups_.size(); i++) {
      output.writeMessage(4, taskGroups_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getAllocationPolicy());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 8);
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(9, getStatus());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(11, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(12, getUpdateTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(13, getLogsPolicy());
    }
    for (int i = 0; i < notifications_.size(); i++) {
      output.writeMessage(14, notifications_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uid_);
    }
    if (priority_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, priority_);
    }
    for (int i = 0; i < taskGroups_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, taskGroups_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getAllocationPolicy());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, labels__);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getStatus());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getUpdateTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getLogsPolicy());
    }
    for (int i = 0; i < notifications_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, notifications_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.batch.v1.Job)) {
      return super.equals(obj);
    }
    com.google.cloud.batch.v1.Job other = (com.google.cloud.batch.v1.Job) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (getPriority() != other.getPriority()) return false;
    if (!getTaskGroupsList().equals(other.getTaskGroupsList())) return false;
    if (hasAllocationPolicy() != other.hasAllocationPolicy()) return false;
    if (hasAllocationPolicy()) {
      if (!getAllocationPolicy().equals(other.getAllocationPolicy())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasLogsPolicy() != other.hasLogsPolicy()) return false;
    if (hasLogsPolicy()) {
      if (!getLogsPolicy().equals(other.getLogsPolicy())) return false;
    }
    if (!getNotificationsList().equals(other.getNotificationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    hash = (37 * hash) + PRIORITY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPriority());
    if (getTaskGroupsCount() > 0) {
      hash = (37 * hash) + TASK_GROUPS_FIELD_NUMBER;
      hash = (53 * hash) + getTaskGroupsList().hashCode();
    }
    if (hasAllocationPolicy()) {
      hash = (37 * hash) + ALLOCATION_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getAllocationPolicy().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasLogsPolicy()) {
      hash = (37 * hash) + LOGS_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getLogsPolicy().hashCode();
    }
    if (getNotificationsCount() > 0) {
      hash = (37 * hash) + NOTIFICATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getNotificationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.batch.v1.Job parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1.Job parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.Job parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1.Job parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.Job parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1.Job parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.Job parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1.Job parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.Job parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1.Job parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.Job parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1.Job parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.batch.v1.Job prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The Cloud Batch Job description.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1.Job}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1.Job)
      com.google.cloud.batch.v1.JobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1.JobProto
          .internal_static_google_cloud_batch_v1_Job_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 8:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 8:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1.JobProto
          .internal_static_google_cloud_batch_v1_Job_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1.Job.class, com.google.cloud.batch.v1.Job.Builder.class);
    }

    // Construct using com.google.cloud.batch.v1.Job.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTaskGroupsFieldBuilder();
        getAllocationPolicyFieldBuilder();
        getStatusFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getLogsPolicyFieldBuilder();
        getNotificationsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uid_ = "";
      priority_ = 0L;
      if (taskGroupsBuilder_ == null) {
        taskGroups_ = java.util.Collections.emptyList();
      } else {
        taskGroups_ = null;
        taskGroupsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      allocationPolicy_ = null;
      if (allocationPolicyBuilder_ != null) {
        allocationPolicyBuilder_.dispose();
        allocationPolicyBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      logsPolicy_ = null;
      if (logsPolicyBuilder_ != null) {
        logsPolicyBuilder_.dispose();
        logsPolicyBuilder_ = null;
      }
      if (notificationsBuilder_ == null) {
        notifications_ = java.util.Collections.emptyList();
      } else {
        notifications_ = null;
        notificationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.batch.v1.JobProto
          .internal_static_google_cloud_batch_v1_Job_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.Job getDefaultInstanceForType() {
      return com.google.cloud.batch.v1.Job.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.Job build() {
      com.google.cloud.batch.v1.Job result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.Job buildPartial() {
      com.google.cloud.batch.v1.Job result = new com.google.cloud.batch.v1.Job(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.batch.v1.Job result) {
      if (taskGroupsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          taskGroups_ = java.util.Collections.unmodifiableList(taskGroups_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.taskGroups_ = taskGroups_;
      } else {
        result.taskGroups_ = taskGroupsBuilder_.build();
      }
      if (notificationsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          notifications_ = java.util.Collections.unmodifiableList(notifications_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.notifications_ = notifications_;
      } else {
        result.notifications_ = notificationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.batch.v1.Job result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uid_ = uid_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.priority_ = priority_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.allocationPolicy_ =
            allocationPolicyBuilder_ == null ? allocationPolicy_ : allocationPolicyBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.logsPolicy_ = logsPolicyBuilder_ == null ? logsPolicy_ : logsPolicyBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.batch.v1.Job) {
        return mergeFrom((com.google.cloud.batch.v1.Job) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.batch.v1.Job other) {
      if (other == com.google.cloud.batch.v1.Job.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getPriority() != 0L) {
        setPriority(other.getPriority());
      }
      if (taskGroupsBuilder_ == null) {
        if (!other.taskGroups_.isEmpty()) {
          if (taskGroups_.isEmpty()) {
            taskGroups_ = other.taskGroups_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureTaskGroupsIsMutable();
            taskGroups_.addAll(other.taskGroups_);
          }
          onChanged();
        }
      } else {
        if (!other.taskGroups_.isEmpty()) {
          if (taskGroupsBuilder_.isEmpty()) {
            taskGroupsBuilder_.dispose();
            taskGroupsBuilder_ = null;
            taskGroups_ = other.taskGroups_;
            bitField0_ = (bitField0_ & ~0x00000008);
            taskGroupsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTaskGroupsFieldBuilder()
                    : null;
          } else {
            taskGroupsBuilder_.addAllMessages(other.taskGroups_);
          }
        }
      }
      if (other.hasAllocationPolicy()) {
        mergeAllocationPolicy(other.getAllocationPolicy());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000020;
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasLogsPolicy()) {
        mergeLogsPolicy(other.getLogsPolicy());
      }
      if (notificationsBuilder_ == null) {
        if (!other.notifications_.isEmpty()) {
          if (notifications_.isEmpty()) {
            notifications_ = other.notifications_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureNotificationsIsMutable();
            notifications_.addAll(other.notifications_);
          }
          onChanged();
        }
      } else {
        if (!other.notifications_.isEmpty()) {
          if (notificationsBuilder_.isEmpty()) {
            notificationsBuilder_.dispose();
            notificationsBuilder_ = null;
            notifications_ = other.notifications_;
            bitField0_ = (bitField0_ & ~0x00000400);
            notificationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNotificationsFieldBuilder()
                    : null;
          } else {
            notificationsBuilder_.addAllMessages(other.notifications_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                priority_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.cloud.batch.v1.TaskGroup m =
                    input.readMessage(
                        com.google.cloud.batch.v1.TaskGroup.parser(), extensionRegistry);
                if (taskGroupsBuilder_ == null) {
                  ensureTaskGroupsIsMutable();
                  taskGroups_.add(m);
                } else {
                  taskGroupsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 58:
              {
                input.readMessage(
                    getAllocationPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            case 66:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 74
            case 90:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getLogsPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 106
            case 114:
              {
                com.google.cloud.batch.v1.JobNotification m =
                    input.readMessage(
                        com.google.cloud.batch.v1.JobNotification.parser(), extensionRegistry);
                if (notificationsBuilder_ == null) {
                  ensureNotificationsIsMutable();
                  notifications_.add(m);
                } else {
                  notificationsBuilder_.addMessage(m);
                }
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Job name.
     * For example: "projects/123456/locations/us-central1/jobs/job01".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Job name.
     * For example: "projects/123456/locations/us-central1/jobs/job01".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Job name.
     * For example: "projects/123456/locations/us-central1/jobs/job01".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Job name.
     * For example: "projects/123456/locations/us-central1/jobs/job01".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Job name.
     * For example: "projects/123456/locations/us-central1/jobs/job01".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";

    /**
     *
     *
     * <pre>
     * Output only. A system generated unique ID for the Job.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A system generated unique ID for the Job.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A system generated unique ID for the Job.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A system generated unique ID for the Job.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A system generated unique ID for the Job.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private long priority_;

    /**
     *
     *
     * <pre>
     * Priority of the Job.
     * The valid value range is [0, 100). Default value is 0.
     * Higher value indicates higher priority.
     * A job with higher priority value is more likely to run earlier if all other
     * requirements are satisfied.
     * </pre>
     *
     * <code>int64 priority = 3;</code>
     *
     * @return The priority.
     */
    @java.lang.Override
    public long getPriority() {
      return priority_;
    }

    /**
     *
     *
     * <pre>
     * Priority of the Job.
     * The valid value range is [0, 100). Default value is 0.
     * Higher value indicates higher priority.
     * A job with higher priority value is more likely to run earlier if all other
     * requirements are satisfied.
     * </pre>
     *
     * <code>int64 priority = 3;</code>
     *
     * @param value The priority to set.
     * @return This builder for chaining.
     */
    public Builder setPriority(long value) {

      priority_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Priority of the Job.
     * The valid value range is [0, 100). Default value is 0.
     * Higher value indicates higher priority.
     * A job with higher priority value is more likely to run earlier if all other
     * requirements are satisfied.
     * </pre>
     *
     * <code>int64 priority = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPriority() {
      bitField0_ = (bitField0_ & ~0x00000004);
      priority_ = 0L;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.batch.v1.TaskGroup> taskGroups_ =
        java.util.Collections.emptyList();

    private void ensureTaskGroupsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        taskGroups_ = new java.util.ArrayList<com.google.cloud.batch.v1.TaskGroup>(taskGroups_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.batch.v1.TaskGroup,
            com.google.cloud.batch.v1.TaskGroup.Builder,
            com.google.cloud.batch.v1.TaskGroupOrBuilder>
        taskGroupsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.batch.v1.TaskGroup> getTaskGroupsList() {
      if (taskGroupsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(taskGroups_);
      } else {
        return taskGroupsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getTaskGroupsCount() {
      if (taskGroupsBuilder_ == null) {
        return taskGroups_.size();
      } else {
        return taskGroupsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.batch.v1.TaskGroup getTaskGroups(int index) {
      if (taskGroupsBuilder_ == null) {
        return taskGroups_.get(index);
      } else {
        return taskGroupsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTaskGroups(int index, com.google.cloud.batch.v1.TaskGroup value) {
      if (taskGroupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTaskGroupsIsMutable();
        taskGroups_.set(index, value);
        onChanged();
      } else {
        taskGroupsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTaskGroups(
        int index, com.google.cloud.batch.v1.TaskGroup.Builder builderForValue) {
      if (taskGroupsBuilder_ == null) {
        ensureTaskGroupsIsMutable();
        taskGroups_.set(index, builderForValue.build());
        onChanged();
      } else {
        taskGroupsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addTaskGroups(com.google.cloud.batch.v1.TaskGroup value) {
      if (taskGroupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTaskGroupsIsMutable();
        taskGroups_.add(value);
        onChanged();
      } else {
        taskGroupsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addTaskGroups(int index, com.google.cloud.batch.v1.TaskGroup value) {
      if (taskGroupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTaskGroupsIsMutable();
        taskGroups_.add(index, value);
        onChanged();
      } else {
        taskGroupsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addTaskGroups(com.google.cloud.batch.v1.TaskGroup.Builder builderForValue) {
      if (taskGroupsBuilder_ == null) {
        ensureTaskGroupsIsMutable();
        taskGroups_.add(builderForValue.build());
        onChanged();
      } else {
        taskGroupsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addTaskGroups(
        int index, com.google.cloud.batch.v1.TaskGroup.Builder builderForValue) {
      if (taskGroupsBuilder_ == null) {
        ensureTaskGroupsIsMutable();
        taskGroups_.add(index, builderForValue.build());
        onChanged();
      } else {
        taskGroupsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllTaskGroups(
        java.lang.Iterable<? extends com.google.cloud.batch.v1.TaskGroup> values) {
      if (taskGroupsBuilder_ == null) {
        ensureTaskGroupsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, taskGroups_);
        onChanged();
      } else {
        taskGroupsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearTaskGroups() {
      if (taskGroupsBuilder_ == null) {
        taskGroups_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        taskGroupsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeTaskGroups(int index) {
      if (taskGroupsBuilder_ == null) {
        ensureTaskGroupsIsMutable();
        taskGroups_.remove(index);
        onChanged();
      } else {
        taskGroupsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.batch.v1.TaskGroup.Builder getTaskGroupsBuilder(int index) {
      return getTaskGroupsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.batch.v1.TaskGroupOrBuilder getTaskGroupsOrBuilder(int index) {
      if (taskGroupsBuilder_ == null) {
        return taskGroups_.get(index);
      } else {
        return taskGroupsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.batch.v1.TaskGroupOrBuilder>
        getTaskGroupsOrBuilderList() {
      if (taskGroupsBuilder_ != null) {
        return taskGroupsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(taskGroups_);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.batch.v1.TaskGroup.Builder addTaskGroupsBuilder() {
      return getTaskGroupsFieldBuilder()
          .addBuilder(com.google.cloud.batch.v1.TaskGroup.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.batch.v1.TaskGroup.Builder addTaskGroupsBuilder(int index) {
      return getTaskGroupsFieldBuilder()
          .addBuilder(index, com.google.cloud.batch.v1.TaskGroup.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. TaskGroups in the Job. Only one TaskGroup is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1.TaskGroup task_groups = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.batch.v1.TaskGroup.Builder> getTaskGroupsBuilderList() {
      return getTaskGroupsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.batch.v1.TaskGroup,
            com.google.cloud.batch.v1.TaskGroup.Builder,
            com.google.cloud.batch.v1.TaskGroupOrBuilder>
        getTaskGroupsFieldBuilder() {
      if (taskGroupsBuilder_ == null) {
        taskGroupsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.batch.v1.TaskGroup,
                com.google.cloud.batch.v1.TaskGroup.Builder,
                com.google.cloud.batch.v1.TaskGroupOrBuilder>(
                taskGroups_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        taskGroups_ = null;
      }
      return taskGroupsBuilder_;
    }

    private com.google.cloud.batch.v1.AllocationPolicy allocationPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.AllocationPolicy,
            com.google.cloud.batch.v1.AllocationPolicy.Builder,
            com.google.cloud.batch.v1.AllocationPolicyOrBuilder>
        allocationPolicyBuilder_;

    /**
     *
     *
     * <pre>
     * Compute resource allocation for all TaskGroups in the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.AllocationPolicy allocation_policy = 7;</code>
     *
     * @return Whether the allocationPolicy field is set.
     */
    public boolean hasAllocationPolicy() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Compute resource allocation for all TaskGroups in the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.AllocationPolicy allocation_policy = 7;</code>
     *
     * @return The allocationPolicy.
     */
    public com.google.cloud.batch.v1.AllocationPolicy getAllocationPolicy() {
      if (allocationPolicyBuilder_ == null) {
        return allocationPolicy_ == null
            ? com.google.cloud.batch.v1.AllocationPolicy.getDefaultInstance()
            : allocationPolicy_;
      } else {
        return allocationPolicyBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Compute resource allocation for all TaskGroups in the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.AllocationPolicy allocation_policy = 7;</code>
     */
    public Builder setAllocationPolicy(com.google.cloud.batch.v1.AllocationPolicy value) {
      if (allocationPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        allocationPolicy_ = value;
      } else {
        allocationPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Compute resource allocation for all TaskGroups in the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.AllocationPolicy allocation_policy = 7;</code>
     */
    public Builder setAllocationPolicy(
        com.google.cloud.batch.v1.AllocationPolicy.Builder builderForValue) {
      if (allocationPolicyBuilder_ == null) {
        allocationPolicy_ = builderForValue.build();
      } else {
        allocationPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Compute resource allocation for all TaskGroups in the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.AllocationPolicy allocation_policy = 7;</code>
     */
    public Builder mergeAllocationPolicy(com.google.cloud.batch.v1.AllocationPolicy value) {
      if (allocationPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && allocationPolicy_ != null
            && allocationPolicy_
                != com.google.cloud.batch.v1.AllocationPolicy.getDefaultInstance()) {
          getAllocationPolicyBuilder().mergeFrom(value);
        } else {
          allocationPolicy_ = value;
        }
      } else {
        allocationPolicyBuilder_.mergeFrom(value);
      }
      if (allocationPolicy_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Compute resource allocation for all TaskGroups in the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.AllocationPolicy allocation_policy = 7;</code>
     */
    public Builder clearAllocationPolicy() {
      bitField0_ = (bitField0_ & ~0x00000010);
      allocationPolicy_ = null;
      if (allocationPolicyBuilder_ != null) {
        allocationPolicyBuilder_.dispose();
        allocationPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Compute resource allocation for all TaskGroups in the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.AllocationPolicy allocation_policy = 7;</code>
     */
    public com.google.cloud.batch.v1.AllocationPolicy.Builder getAllocationPolicyBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getAllocationPolicyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Compute resource allocation for all TaskGroups in the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.AllocationPolicy allocation_policy = 7;</code>
     */
    public com.google.cloud.batch.v1.AllocationPolicyOrBuilder getAllocationPolicyOrBuilder() {
      if (allocationPolicyBuilder_ != null) {
        return allocationPolicyBuilder_.getMessageOrBuilder();
      } else {
        return allocationPolicy_ == null
            ? com.google.cloud.batch.v1.AllocationPolicy.getDefaultInstance()
            : allocationPolicy_;
      }
    }

    /**
     *
     *
     * <pre>
     * Compute resource allocation for all TaskGroups in the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.AllocationPolicy allocation_policy = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.AllocationPolicy,
            com.google.cloud.batch.v1.AllocationPolicy.Builder,
            com.google.cloud.batch.v1.AllocationPolicyOrBuilder>
        getAllocationPolicyFieldBuilder() {
      if (allocationPolicyBuilder_ == null) {
        allocationPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1.AllocationPolicy,
                com.google.cloud.batch.v1.AllocationPolicy.Builder,
                com.google.cloud.batch.v1.AllocationPolicyOrBuilder>(
                getAllocationPolicy(), getParentForChildren(), isClean());
        allocationPolicy_ = null;
      }
      return allocationPolicyBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Custom labels to apply to the job and any Cloud Logging
     * [LogEntry](https://cloud.google.com/logging/docs/reference/v2/rest/v2/LogEntry)
     * that it generates.
     *
     * Use labels to group and describe the resources they are applied to. Batch
     * automatically applies predefined labels and supports multiple `labels`
     * fields for each job, which each let you apply custom labels to various
     * resources. Label names that start with "goog-" or "google-" are
     * reserved for predefined labels. For more information about labels with
     * Batch, see
     * [Organize resources using
     * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Custom labels to apply to the job and any Cloud Logging
     * [LogEntry](https://cloud.google.com/logging/docs/reference/v2/rest/v2/LogEntry)
     * that it generates.
     *
     * Use labels to group and describe the resources they are applied to. Batch
     * automatically applies predefined labels and supports multiple `labels`
     * fields for each job, which each let you apply custom labels to various
     * resources. Label names that start with "goog-" or "google-" are
     * reserved for predefined labels. For more information about labels with
     * Batch, see
     * [Organize resources using
     * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Custom labels to apply to the job and any Cloud Logging
     * [LogEntry](https://cloud.google.com/logging/docs/reference/v2/rest/v2/LogEntry)
     * that it generates.
     *
     * Use labels to group and describe the resources they are applied to. Batch
     * automatically applies predefined labels and supports multiple `labels`
     * fields for each job, which each let you apply custom labels to various
     * resources. Label names that start with "goog-" or "google-" are
     * reserved for predefined labels. For more information about labels with
     * Batch, see
     * [Organize resources using
     * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Custom labels to apply to the job and any Cloud Logging
     * [LogEntry](https://cloud.google.com/logging/docs/reference/v2/rest/v2/LogEntry)
     * that it generates.
     *
     * Use labels to group and describe the resources they are applied to. Batch
     * automatically applies predefined labels and supports multiple `labels`
     * fields for each job, which each let you apply custom labels to various
     * resources. Label names that start with "goog-" or "google-" are
     * reserved for predefined labels. For more information about labels with
     * Batch, see
     * [Organize resources using
     * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Custom labels to apply to the job and any Cloud Logging
     * [LogEntry](https://cloud.google.com/logging/docs/reference/v2/rest/v2/LogEntry)
     * that it generates.
     *
     * Use labels to group and describe the resources they are applied to. Batch
     * automatically applies predefined labels and supports multiple `labels`
     * fields for each job, which each let you apply custom labels to various
     * resources. Label names that start with "goog-" or "google-" are
     * reserved for predefined labels. For more information about labels with
     * Batch, see
     * [Organize resources using
     * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000020;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Custom labels to apply to the job and any Cloud Logging
     * [LogEntry](https://cloud.google.com/logging/docs/reference/v2/rest/v2/LogEntry)
     * that it generates.
     *
     * Use labels to group and describe the resources they are applied to. Batch
     * automatically applies predefined labels and supports multiple `labels`
     * fields for each job, which each let you apply custom labels to various
     * resources. Label names that start with "goog-" or "google-" are
     * reserved for predefined labels. For more information about labels with
     * Batch, see
     * [Organize resources using
     * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Custom labels to apply to the job and any Cloud Logging
     * [LogEntry](https://cloud.google.com/logging/docs/reference/v2/rest/v2/LogEntry)
     * that it generates.
     *
     * Use labels to group and describe the resources they are applied to. Batch
     * automatically applies predefined labels and supports multiple `labels`
     * fields for each job, which each let you apply custom labels to various
     * resources. Label names that start with "goog-" or "google-" are
     * reserved for predefined labels. For more information about labels with
     * Batch, see
     * [Organize resources using
     * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private com.google.cloud.batch.v1.JobStatus status_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.JobStatus,
            com.google.cloud.batch.v1.JobStatus.Builder,
            com.google.cloud.batch.v1.JobStatusOrBuilder>
        statusBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Job status. It is read only for users.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1.JobStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Job status. It is read only for users.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1.JobStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The status.
     */
    public com.google.cloud.batch.v1.JobStatus getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null ? com.google.cloud.batch.v1.JobStatus.getDefaultInstance() : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Job status. It is read only for users.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1.JobStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatus(com.google.cloud.batch.v1.JobStatus value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
      } else {
        statusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Job status. It is read only for users.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1.JobStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatus(com.google.cloud.batch.v1.JobStatus.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Job status. It is read only for users.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1.JobStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStatus(com.google.cloud.batch.v1.JobStatus value) {
      if (statusBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && status_ != null
            && status_ != com.google.cloud.batch.v1.JobStatus.getDefaultInstance()) {
          getStatusBuilder().mergeFrom(value);
        } else {
          status_ = value;
        }
      } else {
        statusBuilder_.mergeFrom(value);
      }
      if (status_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Job status. It is read only for users.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1.JobStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000040);
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Job status. It is read only for users.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1.JobStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.batch.v1.JobStatus.Builder getStatusBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Job status. It is read only for users.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1.JobStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.batch.v1.JobStatusOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null ? com.google.cloud.batch.v1.JobStatus.getDefaultInstance() : status_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Job status. It is read only for users.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1.JobStatus status = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.JobStatus,
            com.google.cloud.batch.v1.JobStatus.Builder,
            com.google.cloud.batch.v1.JobStatusOrBuilder>
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1.JobStatus,
                com.google.cloud.batch.v1.JobStatus.Builder,
                com.google.cloud.batch.v1.JobStatusOrBuilder>(
                getStatus(), getParentForChildren(), isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. When the Job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. When the Job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. When the Job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. When the Job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. When the Job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. When the Job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. When the Job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. When the Job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. When the Job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The last time the Job was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The last time the Job was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The last time the Job was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The last time the Job was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The last time the Job was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The last time the Job was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The last time the Job was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The last time the Job was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The last time the Job was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.cloud.batch.v1.LogsPolicy logsPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.LogsPolicy,
            com.google.cloud.batch.v1.LogsPolicy.Builder,
            com.google.cloud.batch.v1.LogsPolicyOrBuilder>
        logsPolicyBuilder_;

    /**
     *
     *
     * <pre>
     * Log preservation policy for the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LogsPolicy logs_policy = 13;</code>
     *
     * @return Whether the logsPolicy field is set.
     */
    public boolean hasLogsPolicy() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Log preservation policy for the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LogsPolicy logs_policy = 13;</code>
     *
     * @return The logsPolicy.
     */
    public com.google.cloud.batch.v1.LogsPolicy getLogsPolicy() {
      if (logsPolicyBuilder_ == null) {
        return logsPolicy_ == null
            ? com.google.cloud.batch.v1.LogsPolicy.getDefaultInstance()
            : logsPolicy_;
      } else {
        return logsPolicyBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Log preservation policy for the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LogsPolicy logs_policy = 13;</code>
     */
    public Builder setLogsPolicy(com.google.cloud.batch.v1.LogsPolicy value) {
      if (logsPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        logsPolicy_ = value;
      } else {
        logsPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Log preservation policy for the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LogsPolicy logs_policy = 13;</code>
     */
    public Builder setLogsPolicy(com.google.cloud.batch.v1.LogsPolicy.Builder builderForValue) {
      if (logsPolicyBuilder_ == null) {
        logsPolicy_ = builderForValue.build();
      } else {
        logsPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Log preservation policy for the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LogsPolicy logs_policy = 13;</code>
     */
    public Builder mergeLogsPolicy(com.google.cloud.batch.v1.LogsPolicy value) {
      if (logsPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && logsPolicy_ != null
            && logsPolicy_ != com.google.cloud.batch.v1.LogsPolicy.getDefaultInstance()) {
          getLogsPolicyBuilder().mergeFrom(value);
        } else {
          logsPolicy_ = value;
        }
      } else {
        logsPolicyBuilder_.mergeFrom(value);
      }
      if (logsPolicy_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Log preservation policy for the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LogsPolicy logs_policy = 13;</code>
     */
    public Builder clearLogsPolicy() {
      bitField0_ = (bitField0_ & ~0x00000200);
      logsPolicy_ = null;
      if (logsPolicyBuilder_ != null) {
        logsPolicyBuilder_.dispose();
        logsPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Log preservation policy for the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LogsPolicy logs_policy = 13;</code>
     */
    public com.google.cloud.batch.v1.LogsPolicy.Builder getLogsPolicyBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getLogsPolicyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Log preservation policy for the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LogsPolicy logs_policy = 13;</code>
     */
    public com.google.cloud.batch.v1.LogsPolicyOrBuilder getLogsPolicyOrBuilder() {
      if (logsPolicyBuilder_ != null) {
        return logsPolicyBuilder_.getMessageOrBuilder();
      } else {
        return logsPolicy_ == null
            ? com.google.cloud.batch.v1.LogsPolicy.getDefaultInstance()
            : logsPolicy_;
      }
    }

    /**
     *
     *
     * <pre>
     * Log preservation policy for the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.LogsPolicy logs_policy = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.LogsPolicy,
            com.google.cloud.batch.v1.LogsPolicy.Builder,
            com.google.cloud.batch.v1.LogsPolicyOrBuilder>
        getLogsPolicyFieldBuilder() {
      if (logsPolicyBuilder_ == null) {
        logsPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1.LogsPolicy,
                com.google.cloud.batch.v1.LogsPolicy.Builder,
                com.google.cloud.batch.v1.LogsPolicyOrBuilder>(
                getLogsPolicy(), getParentForChildren(), isClean());
        logsPolicy_ = null;
      }
      return logsPolicyBuilder_;
    }

    private java.util.List<com.google.cloud.batch.v1.JobNotification> notifications_ =
        java.util.Collections.emptyList();

    private void ensureNotificationsIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        notifications_ =
            new java.util.ArrayList<com.google.cloud.batch.v1.JobNotification>(notifications_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.batch.v1.JobNotification,
            com.google.cloud.batch.v1.JobNotification.Builder,
            com.google.cloud.batch.v1.JobNotificationOrBuilder>
        notificationsBuilder_;

    /**
     *
     *
     * <pre>
     * Notification configurations.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
     */
    public java.util.List<com.google.cloud.batch.v1.JobNotification> getNotificationsList() {
      if (notificationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(notifications_);
      } else {
        return notificationsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Notification configurations.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
     */
    public int getNotificationsCount() {
      if (notificationsBuilder_ == null) {
        return notifications_.size();
      } else {
        return notificationsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Notification configurations.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
     */
    public com.google.cloud.batch.v1.JobNotification getNotifications(int index) {
      if (notificationsBuilder_ == null) {
        return notifications_.get(index);
      } else {
        return notificationsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Notification configurations.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
     */
    public Builder setNotifications(int index, com.google.cloud.batch.v1.JobNotification value) {
      if (notificationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNotificationsIsMutable();
        notifications_.set(index, value);
        onChanged();
      } else {
        notificationsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Notification configurations.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
     */
    public Builder setNotifications(
        int index, com.google.cloud.batch.v1.JobNotification.Builder builderForValue) {
      if (notificationsBuilder_ == null) {
        ensureNotificationsIsMutable();
        notifications_.set(index, builderForValue.build());
        onChanged();
      } else {
        notificationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Notification configurations.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
     */
    public Builder addNotifications(com.google.cloud.batch.v1.JobNotification value) {
      if (notificationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNotificationsIsMutable();
        notifications_.add(value);
        onChanged();
      } else {
        notificationsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Notification configurations.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
     */
    public Builder addNotifications(int index, com.google.cloud.batch.v1.JobNotification value) {
      if (notificationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNotificationsIsMutable();
        notifications_.add(index, value);
        onChanged();
      } else {
        notificationsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Notification configurations.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
     */
    public Builder addNotifications(
        com.google.cloud.batch.v1.JobNotification.Builder builderForValue) {
      if (notificationsBuilder_ == null) {
        ensureNotificationsIsMutable();
        notifications_.add(builderForValue.build());
        onChanged();
      } else {
        notificationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Notification configurations.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
     */
    public Builder addNotifications(
        int index, com.google.cloud.batch.v1.JobNotification.Builder builderForValue) {
      if (notificationsBuilder_ == null) {
        ensureNotificationsIsMutable();
        notifications_.add(index, builderForValue.build());
        onChanged();
      } else {
        notificationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Notification configurations.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
     */
    public Builder addAllNotifications(
        java.lang.Iterable<? extends com.google.cloud.batch.v1.JobNotification> values) {
      if (notificationsBuilder_ == null) {
        ensureNotificationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, notifications_);
        onChanged();
      } else {
        notificationsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Notification configurations.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
     */
    public Builder clearNotifications() {
      if (notificationsBuilder_ == null) {
        notifications_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        notificationsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Notification configurations.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
     */
    public Builder removeNotifications(int index) {
      if (notificationsBuilder_ == null) {
        ensureNotificationsIsMutable();
        notifications_.remove(index);
        onChanged();
      } else {
        notificationsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Notification configurations.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
     */
    public com.google.cloud.batch.v1.JobNotification.Builder getNotificationsBuilder(int index) {
      return getNotificationsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Notification configurations.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
     */
    public com.google.cloud.batch.v1.JobNotificationOrBuilder getNotificationsOrBuilder(int index) {
      if (notificationsBuilder_ == null) {
        return notifications_.get(index);
      } else {
        return notificationsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Notification configurations.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
     */
    public java.util.List<? extends com.google.cloud.batch.v1.JobNotificationOrBuilder>
        getNotificationsOrBuilderList() {
      if (notificationsBuilder_ != null) {
        return notificationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(notifications_);
      }
    }

    /**
     *
     *
     * <pre>
     * Notification configurations.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
     */
    public com.google.cloud.batch.v1.JobNotification.Builder addNotificationsBuilder() {
      return getNotificationsFieldBuilder()
          .addBuilder(com.google.cloud.batch.v1.JobNotification.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Notification configurations.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
     */
    public com.google.cloud.batch.v1.JobNotification.Builder addNotificationsBuilder(int index) {
      return getNotificationsFieldBuilder()
          .addBuilder(index, com.google.cloud.batch.v1.JobNotification.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Notification configurations.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1.JobNotification notifications = 14;</code>
     */
    public java.util.List<com.google.cloud.batch.v1.JobNotification.Builder>
        getNotificationsBuilderList() {
      return getNotificationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.batch.v1.JobNotification,
            com.google.cloud.batch.v1.JobNotification.Builder,
            com.google.cloud.batch.v1.JobNotificationOrBuilder>
        getNotificationsFieldBuilder() {
      if (notificationsBuilder_ == null) {
        notificationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.batch.v1.JobNotification,
                com.google.cloud.batch.v1.JobNotification.Builder,
                com.google.cloud.batch.v1.JobNotificationOrBuilder>(
                notifications_,
                ((bitField0_ & 0x00000400) != 0),
                getParentForChildren(),
                isClean());
        notifications_ = null;
      }
      return notificationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1.Job)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.batch.v1.Job)
  private static final com.google.cloud.batch.v1.Job DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.batch.v1.Job();
  }

  public static com.google.cloud.batch.v1.Job getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Job> PARSER =
      new com.google.protobuf.AbstractParser<Job>() {
        @java.lang.Override
        public Job parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Job> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Job> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.batch.v1.Job getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
