/*
 * Decompiled with CFR 0.152.
 */
package com.github.rtyley.android.screenshot.paparazzo.processors;

import com.github.rtyley.android.screenshot.paparazzo.processors.ScreenshotProcessor;
import com.madgag.gif.fmsware.AnimatedGifEncoder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Map;

public class AnimatedGifCreator
implements ScreenshotProcessor {
    private final AnimatedGifEncoder gifEncoder;
    private final File file;

    public AnimatedGifCreator(File file) {
        this.file = file;
        this.gifEncoder = new AnimatedGifEncoder();
        this.gifEncoder.setDelay(500);
        this.gifEncoder.setRepeat(0);
    }

    @Override
    public void process(BufferedImage image, Map<String, String> requestData) {
        if (!this.gifEncoder.isStarted()) {
            this.gifEncoder.start(this.file.getAbsolutePath());
        }
        this.gifEncoder.addFrame(image);
    }

    @Override
    public void finish() {
        this.gifEncoder.finish();
    }
}

