/*
 * Decompiled with CFR 0.152.
 */
package com.github.miachm.sods;

import com.github.miachm.sods.GroupCell;
import com.github.miachm.sods.Style;

class Cell
implements Cloneable {
    private Object value;
    private String formula;
    private Style style = new Style();
    private GroupCell group;

    Cell() {
    }

    GroupCell getGroup() {
        return this.group;
    }

    void setGroup(GroupCell group) {
        this.group = group;
    }

    Style getStyle() {
        return this.style;
    }

    Style getStyleCopy() {
        try {
            return (Style)this.style.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e.toString());
        }
    }

    void setStyle(Style style) {
        if (style == null) {
            throw new IllegalArgumentException("Style can not be null");
        }
        try {
            this.style = (Style)style.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)"Style is not cloneable");
        }
    }

    void clear() {
        this.value = null;
        this.formula = null;
        this.style = new Style();
    }

    String getFormula() {
        return this.formula;
    }

    Object getValue() {
        return this.value;
    }

    void setValue(Object value) {
        this.value = value;
    }

    public void setFormula(String formula) {
        if (formula != null && formula.startsWith("of:")) {
            formula = this.convertFormula(formula);
        }
        this.formula = formula;
    }

    private String convertFormula(String formula) {
        formula = formula.trim();
        formula = formula.substring("of:".length());
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < formula.length(); ++i) {
            char character = formula.charAt(i);
            if (character == '[' || character == ']' || character == '.') continue;
            result.append(character);
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cell cell = (Cell)o;
        GroupCell groupCell = this.getGroup();
        if (groupCell != null && groupCell.getCell() != this) {
            if (!groupCell.equals(cell.getGroup())) {
                return false;
            }
            return groupCell.getCell().equals(cell.getGroup().getCell());
        }
        if (this.value != null ? !this.value.equals(cell.value) : cell.value != null) {
            return false;
        }
        if (this.formula != null ? !this.formula.equals(cell.formula) : cell.formula != null) {
            return false;
        }
        return this.style.equals(cell.getStyle());
    }

    public int hashCode() {
        GroupCell groupCell = this.getGroup();
        if (groupCell != null && groupCell.getCell() != this) {
            return groupCell.getCell().hashCode();
        }
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.formula != null ? this.formula.hashCode() : 0);
        result = 31 * result + this.style.hashCode();
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.getGroup() != null) {
            return "Cell{value=" + this.value + ", formula='" + this.formula + '\'' + ", style=" + this.style + '}';
        }
        return this.getGroup().getCell().toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

