/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.reader;

import com.github.kongchen.swagger.docgen.GenerateException;
import com.github.kongchen.swagger.docgen.LogAdapter;
import com.github.kongchen.swagger.docgen.reader.AbstractReader;
import com.github.kongchen.swagger.docgen.reader.ClassSwaggerReader;
import com.github.kongchen.swagger.docgen.spring.SpringResource;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import com.wordnik.swagger.annotations.AuthorizationScope;
import com.wordnik.swagger.converter.ModelConverters;
import com.wordnik.swagger.models.Model;
import com.wordnik.swagger.models.Operation;
import com.wordnik.swagger.models.Response;
import com.wordnik.swagger.models.SecurityDefinition;
import com.wordnik.swagger.models.SecurityRequirement;
import com.wordnik.swagger.models.Swagger;
import com.wordnik.swagger.models.Tag;
import com.wordnik.swagger.models.parameters.Parameter;
import com.wordnik.swagger.models.properties.ArrayProperty;
import com.wordnik.swagger.models.properties.MapProperty;
import com.wordnik.swagger.models.properties.Property;
import com.wordnik.swagger.models.properties.RefProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.util.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

public class SpringMvcApiReader
extends AbstractReader
implements ClassSwaggerReader {
    private String resourcePath;

    public SpringMvcApiReader(Swagger swagger, LogAdapter log) {
        super(swagger, log);
    }

    @Override
    public Swagger read(Set<Class<?>> classes) throws GenerateException {
        Map<String, SpringResource> resourceMap = this.generateResourceMap(classes);
        for (String str : resourceMap.keySet()) {
            SpringResource resource = resourceMap.get(str);
            this.read(resource);
        }
        return this.swagger;
    }

    public Swagger read(SpringResource resource) {
        if (this.swagger == null) {
            this.swagger = new Swagger();
        }
        List<Method> methods = resource.getMethods();
        HashMap<String, Tag> tags = new HashMap();
        ArrayList<SecurityRequirement> resourceSecurities = new ArrayList();
        Class<?> controller = resource.getControllerClass();
        RequestMapping controllerRM = controller.getAnnotation(RequestMapping.class);
        String[] controllerProduces = new String[]{};
        String[] controllerConsumes = new String[]{};
        if (controllerRM != null) {
            controllerConsumes = controllerRM.consumes();
            controllerProduces = controllerRM.produces();
        }
        if (controller != null && controller.isAnnotationPresent(Api.class)) {
            Api api = controller.getAnnotation(Api.class);
            if (!this.canReadApi(false, api)) {
                return this.swagger;
            }
            tags = this.updateTagsForApi(null, api);
            resourceSecurities = this.getSecurityRequirements(api);
            String string = api.description();
        }
        this.resourcePath = resource.getControllerMapping();
        Map<String, List<Method>> apiMethodMap = this.collectApisByRequestMapping(methods);
        for (String path : apiMethodMap.keySet()) {
            for (Method method : apiMethodMap.get(path)) {
                ApiOperation apiOperation;
                RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
                if (requestMapping == null || (apiOperation = method.getAnnotation(ApiOperation.class)) == null) continue;
                String httpMethod = null;
                HashMap<String, String> regexMap = new HashMap<String, String>();
                String operationPath = this.parseOperationPath(path, regexMap);
                for (RequestMethod requestMethod : requestMapping.method()) {
                    httpMethod = requestMethod.toString().toLowerCase();
                    Operation operation = this.parseMethod(method);
                    this.updateOperationParameters(new ArrayList<Parameter>(), regexMap, operation);
                    this.updateOperationProtocols(apiOperation, operation);
                    String[] apiProduces = requestMapping.produces();
                    String[] apiConsumes = requestMapping.consumes();
                    apiProduces = apiProduces == null || apiProduces.length == 0 ? controllerProduces : apiProduces;
                    apiConsumes = apiConsumes == null || apiProduces.length == 0 ? controllerConsumes : apiConsumes;
                    apiConsumes = this.updateOperationConsumes(new String[0], apiConsumes, operation);
                    apiProduces = this.updateOperationProduces(new String[0], apiProduces, operation);
                    this.updateTagsForOperation(operation, apiOperation);
                    this.updateOperation(apiConsumes, apiProduces, tags, resourceSecurities, operation);
                    this.updatePath(operationPath, httpMethod, operation);
                }
            }
        }
        return this.swagger;
    }

    private Operation parseMethod(Method method) {
        ApiResponses responseAnnotation;
        Operation operation = new Operation();
        RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
        Class<?> responseClass = null;
        ArrayList<String> produces = new ArrayList<String>();
        ArrayList<String> consumes = new ArrayList<String>();
        String responseContainer = null;
        String operationId = method.getName();
        ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
        if (apiOperation.hidden()) {
            return null;
        }
        if (!"".equals(apiOperation.nickname())) {
            operationId = apiOperation.nickname();
        }
        Map<String, Property> defaultResponseHeaders = this.parseResponseHeaders(apiOperation.responseHeaders());
        operation.summary(apiOperation.value()).description(apiOperation.notes());
        if (apiOperation.response() != null && !Void.class.equals((Object)apiOperation.response())) {
            responseClass = apiOperation.response();
        }
        if (!"".equals(apiOperation.responseContainer())) {
            responseContainer = apiOperation.responseContainer();
        }
        if (apiOperation.authorizations() != null) {
            ArrayList<SecurityRequirement> securities = new ArrayList<SecurityRequirement>();
            for (Authorization auth : apiOperation.authorizations()) {
                AuthorizationScope[] scopes;
                if (auth.value() == null || "".equals(auth.value())) continue;
                SecurityRequirement security = new SecurityRequirement();
                security.setName(auth.value());
                for (AuthorizationScope scope : scopes = auth.scopes()) {
                    SecurityDefinition definition = new SecurityDefinition(auth.type());
                    if (scope.scope() == null || "".equals(scope.scope())) continue;
                    security.addScope(scope.scope());
                    definition.scope(scope.scope(), scope.description());
                }
                securities.add(security);
            }
            if (securities.size() > 0) {
                for (SecurityRequirement sec : securities) {
                    operation.security(sec);
                }
            }
        }
        if (responseClass == null) {
            this.LOG.info("picking up response class from method " + method);
            Type t = method.getGenericReturnType();
            responseClass = method.getReturnType();
            if (responseClass.equals(ResponseEntity.class)) {
                responseClass = this.getGenericSubtype(method.getReturnType(), method.getGenericReturnType());
            }
            if (!responseClass.equals(Void.class) && !"void".equals(responseClass.toString()) && responseClass.getAnnotation(Api.class) == null) {
                this.LOG.info("reading model " + responseClass);
                Map models = ModelConverters.getInstance().readAll(t);
            }
        }
        if (responseClass != null && !responseClass.equals(Void.class) && !responseClass.equals(ResponseEntity.class) && responseClass.getAnnotation(Api.class) == null) {
            if (this.isPrimitive(responseClass)) {
                Object responseProperty = null;
                Property property = ModelConverters.getInstance().readAsProperty(responseClass);
                if (property != null) {
                    responseProperty = "list".equalsIgnoreCase(responseContainer) ? new ArrayProperty(property) : ("map".equalsIgnoreCase(responseContainer) ? new MapProperty(property) : property);
                    operation.response(200, new Response().description("successful operation").schema((Property)responseProperty).headers(defaultResponseHeaders));
                }
            } else if (!responseClass.equals(Void.class) && !"void".equals(responseClass.toString())) {
                Object models = ModelConverters.getInstance().read(responseClass);
                if (models.size() == 0) {
                    Property pp = ModelConverters.getInstance().readAsProperty(responseClass);
                    operation.response(200, new Response().description("successful operation").schema(pp).headers(defaultResponseHeaders));
                }
                for (String key : models.keySet()) {
                    Object responseProperty = null;
                    responseProperty = "list".equalsIgnoreCase(responseContainer) ? new ArrayProperty((Property)new RefProperty().asDefault(key)) : ("map".equalsIgnoreCase(responseContainer) ? new MapProperty((Property)new RefProperty().asDefault(key)) : new RefProperty().asDefault(key));
                    operation.response(200, new Response().description("successful operation").schema((Property)responseProperty).headers(defaultResponseHeaders));
                    this.swagger.model(key, (Model)models.get(key));
                }
                models = ModelConverters.getInstance().readAll(responseClass);
                for (String key : models.keySet()) {
                    this.swagger.model(key, (Model)models.get(key));
                }
            }
        }
        operation.operationId(operationId);
        if (requestMapping.produces() != null) {
            for (String str : Arrays.asList(requestMapping.produces())) {
                if (produces.contains(str)) continue;
                produces.add(str);
            }
        }
        if (requestMapping.consumes() != null) {
            for (String str : Arrays.asList(requestMapping.consumes())) {
                if (consumes.contains(str)) continue;
                consumes.add(str);
            }
        }
        if ((responseAnnotation = method.getAnnotation(ApiResponses.class)) != null) {
            this.updateApiResponse(operation, responseAnnotation);
        } else {
            ResponseStatus responseStatus = method.getAnnotation(ResponseStatus.class);
            if (responseStatus != null) {
                operation.response(responseStatus.value().value(), new Response().description(responseStatus.reason()));
            }
        }
        boolean isDeprecated = false;
        Deprecated annotation = method.getAnnotation(Deprecated.class);
        if (annotation != null) {
            isDeprecated = true;
        }
        boolean hidden = false;
        if (apiOperation != null) {
            hidden = apiOperation.hidden();
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> cls = parameterTypes[i];
            Type type = genericParameterTypes[i];
            List<Parameter> parameters = this.getParameters(cls, type, paramAnnotations[i]);
            for (Parameter parameter : parameters) {
                operation.parameter(parameter);
            }
        }
        if (operation.getResponses() == null) {
            operation.defaultResponse(new Response().description("successful operation"));
        }
        List<Parameter> extractedApiImplicitParams = this.getParametersFromApiImplicitParams(method);
        for (Parameter extractedApiImplicitParam : extractedApiImplicitParams) {
            operation.parameter(extractedApiImplicitParam);
        }
        return operation;
    }

    private Map<String, List<Method>> collectApisByRequestMapping(List<Method> methods) {
        HashMap<String, List<Method>> apiMethodMap = new HashMap<String, List<Method>>();
        for (Method method : methods) {
            if (!method.isAnnotationPresent(RequestMapping.class)) continue;
            RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
            String path = "";
            path = requestMapping.value() != null && requestMapping.value().length != 0 ? this.generateFullPath(requestMapping.value()[0]) : this.resourcePath;
            if (apiMethodMap.containsKey(path)) {
                ((List)apiMethodMap.get(path)).add(method);
                continue;
            }
            ArrayList<Method> ms = new ArrayList<Method>();
            ms.add(method);
            apiMethodMap.put(path, ms);
        }
        return apiMethodMap;
    }

    private String generateFullPath(String path) {
        if (StringUtils.isNotEmpty((String)path)) {
            return this.resourcePath + (path.startsWith("/") ? path : '/' + path);
        }
        return this.resourcePath;
    }

    private Class<?> getGenericSubtype(Class<?> clazz, Type t) {
        if (!clazz.getName().equals("void") && !t.toString().equals("void")) {
            try {
                ParameterizedType paramType = (ParameterizedType)t;
                Type[] argTypes = paramType.getActualTypeArguments();
                if (argTypes.length > 0) {
                    Class c = (Class)argTypes[0];
                    return c;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return clazz;
    }

    private Map<String, SpringResource> analyzeController(Class<?> clazz, Map<String, SpringResource> resourceMap, String description) throws ClassNotFoundException {
        String controllerCanonicalName = clazz.getCanonicalName();
        for (int i = 0; i < clazz.getAnnotation(RequestMapping.class).value().length; ++i) {
            Method[] methods;
            String controllerRequestMappingValue = clazz.getAnnotation(RequestMapping.class).value()[i];
            for (Method method : methods = clazz.getMethods()) {
                RequestMethod[] requestMappingRequestMethods;
                RequestMapping methodRequestMapping = method.getAnnotation(RequestMapping.class);
                if (!(methodRequestMapping instanceof RequestMapping)) continue;
                for (RequestMethod requestMappingRequestMethod : requestMappingRequestMethods = methodRequestMapping.method()) {
                    String[] methodRequestMappingValues = methodRequestMapping.value();
                    if (methodRequestMappingValues == null || methodRequestMappingValues.length == 0) {
                        String resourceKey = controllerCanonicalName + controllerRequestMappingValue + requestMappingRequestMethod;
                        if (!resourceMap.containsKey(resourceKey)) {
                            resourceMap.put(resourceKey, new SpringResource(clazz, controllerRequestMappingValue, resourceKey, description));
                        }
                        resourceMap.get(resourceKey).addMethod(method);
                        continue;
                    }
                    String[] stringArray = methodRequestMappingValues;
                    int n = stringArray.length;
                    for (int j = 0; j < n; ++j) {
                        String methodRequestMappingValue;
                        String resourceName = methodRequestMappingValue = stringArray[j];
                        String resourceKey = controllerCanonicalName + controllerRequestMappingValue + resourceName + requestMappingRequestMethod;
                        if (resourceName.equals("")) continue;
                        if (!resourceMap.containsKey(resourceKey)) {
                            resourceMap.put(resourceKey, new SpringResource(clazz, resourceName, resourceKey, description));
                        }
                        resourceMap.get(resourceKey).addMethod(method);
                    }
                }
            }
        }
        clazz.getFields();
        clazz.getDeclaredFields();
        return resourceMap;
    }

    private Map<String, SpringResource> generateResourceMap(Set<Class<?>> validClasses) throws GenerateException {
        Map<String, SpringResource> resourceMap = new HashMap<String, SpringResource>();
        for (Class<?> c : validClasses) {
            RequestMapping requestMapping = c.getAnnotation(RequestMapping.class);
            String description = "";
            if (requestMapping == null || requestMapping.value().length == 0) continue;
            try {
                resourceMap = this.analyzeController(c, resourceMap, description);
                ArrayList<Method> mList = new ArrayList<Method>(Arrays.asList(c.getMethods()));
                if (c.getSuperclass() == null) continue;
                mList.addAll(Arrays.asList(c.getSuperclass().getMethods()));
            }
            catch (NoClassDefFoundError e) {
                this.LOG.error(e.getMessage());
                this.LOG.info(c.getName());
            }
            catch (ClassNotFoundException e) {
                this.LOG.error(e.getMessage());
                this.LOG.info(c.getName());
            }
        }
        return resourceMap;
    }
}

