/*
 * Decompiled with CFR 0.152.
 */
package smile.datasets;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.csv.CSVFormat;
import smile.data.CategoricalEncoder;
import smile.data.DataFrame;
import smile.data.formula.Formula;
import smile.io.Paths;
import smile.io.Read;

public record Default(DataFrame data, Formula formula) {
    public Default() throws IOException {
        this(Paths.getTestData("classification/default.csv"));
    }

    public Default(Path path) throws IOException {
        this(Default.load(path), Formula.lhs("default"));
    }

    private static DataFrame load(Path path) throws IOException {
        CSVFormat format = CSVFormat.Builder.create().setHeader(new String[0]).setSkipHeaderRecord(true).get();
        return Read.csv(path, format).factorize(new String[0]);
    }

    public double[][] x() {
        return this.formula.x(this.data).toArray(false, CategoricalEncoder.DUMMY, new String[0]);
    }

    public int[] y() {
        return this.formula.y(this.data).toIntArray();
    }
}

