/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.stream.IntStream;
import smile.data.measure.NumericalMeasure;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.PrimitiveVector;
import smile.util.Index;

public class CharVector
extends PrimitiveVector {
    private final char[] vector;

    public CharVector(String name, char[] vector) {
        this(new StructField(name, DataTypes.CharType), vector);
    }

    public CharVector(StructField field, char[] vector) {
        if (field.dtype() != DataTypes.CharType) {
            throw new IllegalArgumentException("Invalid data type: " + String.valueOf(field));
        }
        if (field.measure() instanceof NumericalMeasure) {
            throw new IllegalArgumentException("Invalid measure: " + String.valueOf(field.measure()));
        }
        super(field);
        this.vector = vector;
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public CharVector withName(String name) {
        return new CharVector(this.field.withName(name), this.vector);
    }

    @Override
    public IntStream intStream() {
        return this.index().map(i -> this.vector[i]);
    }

    @Override
    public void set(int i, Object value) {
        if (!(value instanceof Character)) {
            throw new IllegalArgumentException("Invalid value type: " + String.valueOf(value.getClass()));
        }
        Character c = (Character)value;
        this.vector[i] = c.charValue();
    }

    @Override
    public CharVector get(Index index) {
        int n = index.size();
        char[] data = new char[n];
        for (int i = 0; i < n; ++i) {
            data[i] = this.vector[index.apply(i)];
        }
        return new CharVector(this.field, data);
    }

    @Override
    public Character get(int i) {
        return Character.valueOf(this.vector[i]);
    }

    @Override
    public char getChar(int i) {
        return this.vector[i];
    }

    @Override
    public boolean getBoolean(int i) {
        return this.vector[i] == 'T';
    }

    @Override
    public byte getByte(int i) {
        return (byte)this.vector[i];
    }

    @Override
    public short getShort(int i) {
        return (short)this.vector[i];
    }

    @Override
    public int getInt(int i) {
        return this.vector[i];
    }

    @Override
    public long getLong(int i) {
        return this.vector[i];
    }

    @Override
    public float getFloat(int i) {
        return this.vector[i];
    }

    @Override
    public double getDouble(int i) {
        return this.vector[i];
    }
}

