/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.math.BigDecimal;
import java.util.BitSet;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.type.DataType;
import smile.data.type.StructField;
import smile.data.vector.BooleanVector;
import smile.data.vector.ByteVector;
import smile.data.vector.CharVector;
import smile.data.vector.DoubleVector;
import smile.data.vector.FloatVector;
import smile.data.vector.IntVector;
import smile.data.vector.LongVector;
import smile.data.vector.NullableBooleanVector;
import smile.data.vector.NullableByteVector;
import smile.data.vector.NullableCharVector;
import smile.data.vector.NullableDoubleVector;
import smile.data.vector.NullableFloatVector;
import smile.data.vector.NullableIntVector;
import smile.data.vector.NullableLongVector;
import smile.data.vector.NullableShortVector;
import smile.data.vector.NumberVector;
import smile.data.vector.ObjectVector;
import smile.data.vector.ShortVector;
import smile.data.vector.StringVector;
import smile.data.vector.ValueVector;

public interface Feature {
    public StructField field();

    public Object apply(Tuple var1);

    default public double applyAsDouble(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    default public float applyAsFloat(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    default public int applyAsInt(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    default public long applyAsLong(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    default public boolean applyAsBoolean(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    default public byte applyAsByte(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    default public short applyAsShort(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    default public char applyAsChar(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    default public String applyAsString(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    default public BigDecimal applyAsDecimal(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    default public boolean isVariable() {
        return false;
    }

    default public ValueVector apply(DataFrame data) {
        StructField field = this.field();
        if (this.isVariable()) {
            return data.column(field.name());
        }
        int size = data.size();
        BitSet nullMask = new BitSet(size);
        ObjectVector vector = switch (field.dtype().id()) {
            case DataType.ID.Int -> {
                Object result;
                int i;
                Object[] values = new int[size];
                if (field.dtype().isNullable()) {
                    for (i = 0; i < size; ++i) {
                        result = this.apply(data.get(i));
                        if (result == null) {
                            nullMask.set(i);
                            values[i] = Integer.MIN_VALUE;
                            continue;
                        }
                        values[i] = ((Number)result).intValue();
                    }
                } else {
                    for (i = 0; i < size; ++i) {
                        values[i] = this.applyAsInt(data.get(i));
                    }
                }
                if (nullMask.isEmpty()) {
                    yield new IntVector(field, (int[])values);
                }
                yield new NullableIntVector(field, (int[])values, nullMask);
            }
            case DataType.ID.Long -> {
                Object result;
                int i;
                Object[] values = new long[size];
                if (field.dtype().isNullable()) {
                    for (i = 0; i < size; ++i) {
                        result = this.apply(data.get(i));
                        if (result == null) {
                            nullMask.set(i);
                            values[i] = (int)Long.MIN_VALUE;
                            continue;
                        }
                        values[i] = (int)((Number)result).longValue();
                    }
                } else {
                    for (i = 0; i < size; ++i) {
                        values[i] = (int)this.applyAsLong(data.get(i));
                    }
                }
                if (nullMask.isEmpty()) {
                    yield new LongVector(field, (long[])values);
                }
                yield new NullableLongVector(field, (long[])values, nullMask);
            }
            case DataType.ID.Double -> {
                Object result;
                int i;
                Object[] values = new double[size];
                if (field.dtype().isNullable()) {
                    for (i = 0; i < size; ++i) {
                        result = this.apply(data.get(i));
                        if (result == null) {
                            nullMask.set(i);
                            values[i] = (int)Double.NaN;
                            continue;
                        }
                        values[i] = (int)((Number)result).doubleValue();
                    }
                } else {
                    for (i = 0; i < size; ++i) {
                        values[i] = (int)this.applyAsDouble(data.get(i));
                    }
                }
                if (nullMask.isEmpty()) {
                    yield new DoubleVector(field, (double[])values);
                }
                yield new NullableDoubleVector(field, (double[])values, nullMask);
            }
            case DataType.ID.Float -> {
                Object result;
                int i;
                Object[] values = new float[size];
                if (field.dtype().isNullable()) {
                    for (i = 0; i < size; ++i) {
                        result = this.apply(data.get(i));
                        if (result == null) {
                            nullMask.set(i);
                            values[i] = (int)Float.NaN;
                            continue;
                        }
                        values[i] = (int)((Number)result).floatValue();
                    }
                } else {
                    for (i = 0; i < size; ++i) {
                        values[i] = (int)this.applyAsFloat(data.get(i));
                    }
                }
                if (nullMask.isEmpty()) {
                    yield new FloatVector(field, (float[])values);
                }
                yield new NullableFloatVector(field, (float[])values, nullMask);
            }
            case DataType.ID.Boolean -> {
                Object result;
                int i;
                Object[] values = new boolean[size];
                if (field.dtype().isNullable()) {
                    for (i = 0; i < size; ++i) {
                        result = this.apply(data.get(i));
                        if (result == null) {
                            nullMask.set(i);
                            continue;
                        }
                        values[i] = ((Boolean)result).booleanValue() ? 1 : 0;
                    }
                } else {
                    for (i = 0; i < size; ++i) {
                        values[i] = this.applyAsBoolean(data.get(i)) ? 1 : 0;
                    }
                }
                if (nullMask.isEmpty()) {
                    yield new BooleanVector(field, (boolean[])values);
                }
                yield new NullableBooleanVector(field, (boolean[])values, nullMask);
            }
            case DataType.ID.Byte -> {
                Object result;
                int i;
                Object[] values = new byte[size];
                if (field.dtype().isNullable()) {
                    for (i = 0; i < size; ++i) {
                        result = this.apply(data.get(i));
                        if (result == null) {
                            nullMask.set(i);
                            values[i] = -128;
                            continue;
                        }
                        values[i] = ((Number)result).byteValue();
                    }
                } else {
                    for (i = 0; i < size; ++i) {
                        values[i] = this.applyAsByte(data.get(i));
                    }
                }
                if (nullMask.isEmpty()) {
                    yield new ByteVector(field, (byte[])values);
                }
                yield new NullableByteVector(field, (byte[])values, nullMask);
            }
            case DataType.ID.Short -> {
                Object result;
                int i;
                Object[] values = new short[size];
                if (field.dtype().isNullable()) {
                    for (i = 0; i < size; ++i) {
                        result = this.apply(data.get(i));
                        if (result == null) {
                            nullMask.set(i);
                            values[i] = Short.MIN_VALUE;
                            continue;
                        }
                        values[i] = ((Number)result).shortValue();
                    }
                } else {
                    for (i = 0; i < size; ++i) {
                        values[i] = this.applyAsShort(data.get(i));
                    }
                }
                if (nullMask.isEmpty()) {
                    yield new ShortVector(field, (short[])values);
                }
                yield new NullableShortVector(field, (short[])values, nullMask);
            }
            case DataType.ID.Char -> {
                Object result;
                int i;
                Object[] values = new char[size];
                if (field.dtype().isNullable()) {
                    for (i = 0; i < size; ++i) {
                        result = this.apply(data.get(i));
                        if (result == null) {
                            nullMask.set(i);
                            values[i] = 0;
                            continue;
                        }
                        values[i] = ((Character)result).charValue();
                    }
                } else {
                    for (i = 0; i < size; ++i) {
                        values[i] = this.applyAsChar(data.get(i));
                    }
                }
                if (nullMask.isEmpty()) {
                    yield new CharVector(field, (char[])values);
                }
                yield new NullableCharVector(field, (char[])values, nullMask);
            }
            case DataType.ID.String -> {
                int i;
                Object[] values = new String[size];
                for (i = 0; i < size; ++i) {
                    values[i] = (int)this.applyAsString(data.get(i));
                }
                yield new StringVector(field, (String[])values);
            }
            case DataType.ID.Decimal -> {
                int i;
                Object[] values = new BigDecimal[size];
                for (i = 0; i < size; ++i) {
                    values[i] = (int)this.applyAsDecimal(data.get(i));
                }
                yield new NumberVector(field, (Number[])values);
            }
            default -> {
                int i;
                Object[] values = new Object[size];
                for (i = 0; i < size; ++i) {
                    values[i] = (int)this.apply(data.get(i));
                }
                yield new ObjectVector<int>(field, values);
            }
        };
        return vector;
    }
}

