/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency.text;

import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.graph.NodeRenderer;
import com.google.common.base.Joiner;
import java.util.Set;
import org.apache.maven.artifact.Artifact;

public class TextDependencyNodeNameRenderer
implements NodeRenderer<DependencyNode> {
    private static final Joiner SLASH_JOINER = Joiner.on((String)"/").skipNulls();
    private static final Joiner COLON_JOINER = Joiner.on((String)":").skipNulls();
    private final boolean showGroupId;
    private final boolean showArtifactId;
    private final boolean showTypes;
    private final boolean showClassifiers;
    private final boolean showVersion;
    private final boolean showOptional;
    private final boolean showScope;

    public TextDependencyNodeNameRenderer(boolean showGroupId, boolean showArtifactId, boolean showTypes, boolean showClassifiers, boolean showVersionsOnNodes, boolean showOptional, boolean showScope) {
        this.showGroupId = showGroupId;
        this.showArtifactId = showArtifactId;
        this.showTypes = showTypes;
        this.showClassifiers = showClassifiers;
        this.showVersion = showVersionsOnNodes;
        this.showOptional = showOptional;
        this.showScope = showScope;
    }

    @Override
    public String render(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        String artifactString = COLON_JOINER.join((Object)(this.showGroupId ? artifact.getGroupId() : null), (Object)(this.showArtifactId ? artifact.getArtifactId() : null), new Object[]{this.showVersion ? node.getEffectiveVersion() : null, this.showTypes ? SLASH_JOINER.join(node.getTypes()) : null, this.showClassifiers ? SLASH_JOINER.join(node.getClassifiers()) : null, this.showScope ? TextDependencyNodeNameRenderer.createScopeString(node.getScopes()) : null});
        if (this.showOptional && artifact.isOptional()) {
            return artifactString + " (optional)";
        }
        return artifactString;
    }

    private static String createScopeString(Set<String> scopes) {
        if (scopes.isEmpty()) {
            return "compile";
        }
        return SLASH_JOINER.join(scopes);
    }
}

