/*
 * Decompiled with CFR 0.152.
 */
package com.edugility.jpa.maven.plugin;

import com.edugility.jpa.maven.plugin.AnnotationDB;
import com.edugility.jpa.maven.plugin.URLFilter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.scannotation.archiveiterator.FileIterator;
import org.scannotation.archiveiterator.FileProtocolIteratorFactory;
import org.scannotation.archiveiterator.Filter;
import org.scannotation.archiveiterator.IteratorFactory;
import org.scannotation.archiveiterator.JarIterator;
import org.scannotation.archiveiterator.StreamIterator;

public abstract class AbstractJPAMojo
extends AbstractMojo {
    private MavenProject project;
    private AnnotationDB db;
    private URLFilter urlFilter;

    protected AbstractJPAMojo() {
    }

    protected AnnotationDB createAnnotationDB() {
        return new AnnotationDB();
    }

    public URLFilter getURLFilter() {
        return this.urlFilter;
    }

    public void setURLFilter(URLFilter filter) {
        this.urlFilter = filter;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public final AnnotationDB cloneAnnotationDB() {
        if (this.db == null) {
            this.db = this.createAnnotationDB();
        }
        if (this.db == null) {
            return null;
        }
        return this.db.clone();
    }

    public void setAnnotationDB(AnnotationDB db) {
        this.db = db;
    }

    protected final AnnotationDB scan(Set<URL> urls) throws IOException {
        AnnotationDB db = this.cloneAnnotationDB();
        AnnotationDB result = this.scan(db, urls);
        assert (result == db);
        return result;
    }

    private final AnnotationDB scan(AnnotationDB db, Set<URL> urls) throws IOException {
        if (db != null && urls != null && !urls.isEmpty()) {
            Log log = this.getLog();
            if (log != null && log.isDebugEnabled()) {
                log.debug((CharSequence)("Scanning the following URLs: " + urls));
            }
            db.clear();
            db.scanArchives(urls.toArray(new URL[urls.size()]));
        }
        return db;
    }

    static {
        Field field = null;
        try {
            field = IteratorFactory.class.getDeclaredField("registry");
            assert (field != null);
            field.setAccessible(true);
            Map registry = (Map)field.get(null);
            assert (registry != null);
            assert (registry.containsKey("file"));
            1 old = registry.put("file", new FileProtocolIteratorFactory(){

                public StreamIterator create(URL url, Filter filter) throws IOException {
                    Object returnValue = null;
                    if (url != null) {
                        File file;
                        try {
                            file = new File(url.toURI());
                        }
                        catch (URISyntaxException e) {
                            file = new File(url.getPath());
                        }
                        returnValue = file.isDirectory() ? new FileIterator(file, filter) : new JarIterator(url.openStream(), filter);
                    }
                    return returnValue;
                }
            });
            assert (old != null);
        }
        catch (Exception ohWell) {
            ohWell.printStackTrace();
        }
    }
}

